/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;
import org.dita.dost.invoker.CliException;
import org.dita.dost.invoker.Main;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.platform.Integrator;

public final class PluginUninstall {
    private String id;
    private DITAOTLogger logger;
    private File ditaDir;
    private Integrator integrator;

    private void init() {
        this.integrator = new Integrator(this.ditaDir);
        this.integrator.setLogger(this.logger);
    }

    public void execute() throws Exception {
        this.init();
        if (this.id == null) {
            throw new BuildException((Throwable)new IllegalStateException("id argument not set"));
        }
        File pluginDir = Paths.get(this.ditaDir.getAbsolutePath(), "plugins", this.id).toFile();
        if (!pluginDir.exists()) {
            throw new CliException(Main.locale.getString("uninstall.error.plugin_not_found").formatted(this.id));
        }
        this.logger.debug("Delete plug-in directory {0}", pluginDir);
        try {
            FileUtils.deleteDirectory((File)pluginDir);
        }
        catch (IOException e) {
            throw new BuildException("Failed to delete plug-in directory %s".formatted(pluginDir), (Throwable)e);
        }
        this.integrator.setLogger(this.logger);
        try {
            this.integrator.execute();
        }
        catch (Exception e) {
            throw new BuildException("Integration failed: " + e.toString(), (Throwable)e);
        }
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public void setDitaDir(File ditaDir) {
        this.ditaDir = ditaDir;
    }

    public void setId(String id) {
        this.id = id;
    }
}

