/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.oidc;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectPrepareAuthenticationRequest;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectPrepareAuthenticationResponse;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.oidc.OpenIdConnectRealm;

public class TransportOpenIdConnectPrepareAuthenticationAction
extends HandledTransportAction<OpenIdConnectPrepareAuthenticationRequest, OpenIdConnectPrepareAuthenticationResponse> {
    private final Realms realms;

    @Inject
    public TransportOpenIdConnectPrepareAuthenticationAction(TransportService transportService, ActionFilters actionFilters, Realms realms) {
        super("cluster:admin/xpack/security/oidc/prepare", transportService, actionFilters, OpenIdConnectPrepareAuthenticationRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.realms = realms;
    }

    protected void doExecute(Task task, OpenIdConnectPrepareAuthenticationRequest request, ActionListener<OpenIdConnectPrepareAuthenticationResponse> listener) {
        Realm realm = null;
        if (Strings.hasText((String)request.getIssuer())) {
            List<OpenIdConnectRealm> matchingRealms = this.realms.stream().filter(r -> r instanceof OpenIdConnectRealm && ((OpenIdConnectRealm)((Object)r)).isIssuerValid(request.getIssuer())).map(r -> (OpenIdConnectRealm)((Object)r)).toList();
            if (matchingRealms.isEmpty()) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Cannot find OpenID Connect realm with issuer [{}]", new Object[]{request.getIssuer()})));
                return;
            }
            if (matchingRealms.size() > 1) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Found multiple OpenID Connect realm with issuer [{}]", new Object[]{request.getIssuer()})));
                return;
            }
            realm = matchingRealms.get(0);
        } else if (Strings.hasText((String)request.getRealmName())) {
            realm = this.realms.realm(request.getRealmName());
        }
        if (realm instanceof OpenIdConnectRealm) {
            TransportOpenIdConnectPrepareAuthenticationAction.prepareAuthenticationResponse((OpenIdConnectRealm)realm, request.getState(), request.getNonce(), request.getLoginHint(), listener);
        } else {
            listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Cannot find OpenID Connect realm with name [{}]", new Object[]{request.getRealmName()})));
        }
    }

    private static void prepareAuthenticationResponse(OpenIdConnectRealm realm, String state, String nonce, String loginHint, ActionListener<OpenIdConnectPrepareAuthenticationResponse> listener) {
        try {
            OpenIdConnectPrepareAuthenticationResponse authenticationResponse = realm.buildAuthenticationRequestUri(state, nonce, loginHint);
            listener.onResponse((Object)authenticationResponse);
        }
        catch (ElasticsearchException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }
}

