/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.CrossClusterAccessAuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.transport.ServerTransportFilter;

final class CrossClusterAccessServerTransportFilter
extends ServerTransportFilter {
    private static final Logger logger = LogManager.getLogger(CrossClusterAccessServerTransportFilter.class);
    static final Set<String> ALLOWED_TRANSPORT_HEADERS;
    private final CrossClusterAccessAuthenticationService crossClusterAccessAuthcService;
    private final XPackLicenseState licenseState;

    CrossClusterAccessServerTransportFilter(CrossClusterAccessAuthenticationService crossClusterAccessAuthcService, AuthorizationService authzService, ThreadContext threadContext, boolean extractClientCert, DestructiveOperations destructiveOperations, SecurityContext securityContext, XPackLicenseState licenseState) {
        super(crossClusterAccessAuthcService.getAuthenticationService(), authzService, threadContext, extractClientCert, destructiveOperations, securityContext);
        this.crossClusterAccessAuthcService = crossClusterAccessAuthcService;
        this.licenseState = licenseState;
    }

    @Override
    protected void authenticate(String securityAction, TransportRequest request, ActionListener<Authentication> authenticationListener) {
        if (!Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.check(this.licenseState)) {
            CrossClusterAccessServerTransportFilter.onFailureWithDebugLog(securityAction, request, authenticationListener, (Exception)((Object)LicenseUtils.newComplianceException((String)Security.ADVANCED_REMOTE_CLUSTER_SECURITY_FEATURE.getName())));
        } else {
            try {
                this.validateHeaders();
            }
            catch (Exception ex) {
                CrossClusterAccessServerTransportFilter.onFailureWithDebugLog(securityAction, request, authenticationListener, ex);
                return;
            }
            this.crossClusterAccessAuthcService.authenticate(securityAction, request, authenticationListener);
        }
    }

    private void validateHeaders() {
        ThreadContext threadContext = this.getThreadContext();
        CrossClusterAccessServerTransportFilter.ensureRequiredHeaderInContext(threadContext, "_cross_cluster_access_credentials");
        CrossClusterAccessServerTransportFilter.ensureRequiredHeaderInContext(threadContext, "_cross_cluster_access_subject_info");
        for (String header : threadContext.getHeaders().keySet()) {
            if (ALLOWED_TRANSPORT_HEADERS.contains(header)) continue;
            throw new IllegalArgumentException("Transport request header [" + header + "] is not allowed for cross cluster requests through the dedicated remote cluster server port");
        }
    }

    private static void ensureRequiredHeaderInContext(ThreadContext threadContext, String requiredHeader) {
        if (threadContext.getHeader(requiredHeader) == null) {
            throw CrossClusterAccessAuthenticationService.requiredHeaderMissingException(requiredHeader);
        }
    }

    private static void onFailureWithDebugLog(String securityAction, TransportRequest request, ActionListener<Authentication> authenticationListener, Exception ex) {
        logger.debug(() -> Strings.format((String)"Cross cluster access request [%s] for action [%s] rejected before authentication", (Object[])new Object[]{request.getClass(), securityAction}), (Throwable)ex);
        authenticationListener.onFailure(ex);
    }

    static {
        HashSet<String> allowedHeaders = new HashSet<String>(Set.of("_cross_cluster_access_credentials", "_cross_cluster_access_subject_info"));
        allowedHeaders.add("_xpack_audit_request_id");
        allowedHeaders.add("tracestate");
        allowedHeaders.addAll(Task.HEADERS_TO_COPY);
        ALLOWED_TRANSPORT_HEADERS = Set.copyOf(allowedHeaders);
    }
}

