/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.BufferLedger;
import org.apache.arrow.memory.LowCostIdentityHashMap;
import org.apache.arrow.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class AllocationManager {
    private final @UnknownKeyFor @NonNull @Initialized BufferAllocator root;
    private final @UnknownKeyFor @NonNull @Initialized LowCostIdentityHashMap<@UnknownKeyFor @NonNull @Initialized BufferAllocator, @UnknownKeyFor @NonNull @Initialized BufferLedger> map = new LowCostIdentityHashMap();
    private volatile @Nullable @UnknownKeyFor @Initialized BufferLedger owningLedger;

    protected AllocationManager(@UnknownKeyFor @NonNull @Initialized BufferAllocator accountingAllocator) {
        Preconditions.checkNotNull(accountingAllocator);
        accountingAllocator.assertOpen();
        this.root = accountingAllocator.getRoot();
        this.owningLedger = this.associate(accountingAllocator, false);
    }

    @Nullable @UnknownKeyFor @Initialized BufferLedger getOwningLedger() {
        return this.owningLedger;
    }

    void setOwningLedger(@UnknownKeyFor @NonNull @Initialized BufferLedger ledger) {
        this.owningLedger = ledger;
    }

    @UnknownKeyFor @NonNull @Initialized BufferLedger associate(@UnknownKeyFor @NonNull @Initialized BufferAllocator allocator) {
        return this.associate(allocator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @UnknownKeyFor @NonNull @Initialized BufferLedger associate(@UnknownKeyFor @NonNull @Initialized BufferAllocator allocator, @UnknownKeyFor @NonNull @Initialized boolean retain) {
        allocator.assertOpen();
        Preconditions.checkState(this.root == allocator.getRoot(), "A buffer can only be associated between two allocators that share the same root");
        AllocationManager allocationManager = this;
        synchronized (allocationManager) {
            BufferLedger oldLedger;
            BufferLedger ledger = this.map.get(allocator);
            if (ledger != null) {
                if (retain) {
                    ledger.increment();
                }
                return ledger;
            }
            ledger = new BufferLedger(allocator, this);
            if (retain) {
                ledger.increment();
            }
            Preconditions.checkState((oldLedger = this.map.put(ledger)) == null, "Detected inconsistent state: A reference manager already exists for this allocator");
            if (allocator instanceof BaseAllocator) {
                ((BaseAllocator)allocator).associateLedger(ledger);
            }
            return ledger;
        }
    }

    void release(@UnknownKeyFor @NonNull @Initialized BufferLedger ledger) {
        BufferAllocator allocator = ledger.getAllocator();
        allocator.assertOpen();
        Preconditions.checkState(this.map.containsKey(allocator), "Expecting a mapping for allocator and reference manager");
        BufferLedger oldLedger = this.map.remove(allocator);
        Preconditions.checkState(oldLedger != null, "Expecting a mapping for allocator and reference manager");
        BufferAllocator oldAllocator = oldLedger.getAllocator();
        if (oldAllocator instanceof BaseAllocator) {
            ((BaseAllocator)oldAllocator).dissociateLedger(oldLedger);
        }
        if (oldLedger == this.owningLedger) {
            if (this.map.isEmpty()) {
                oldAllocator.releaseBytes(this.getSize());
                this.release0();
                oldAllocator.getListener().onRelease(this.getSize());
                this.owningLedger = null;
            } else {
                BufferLedger newOwningLedger = this.map.getNextValue();
                oldLedger.transferBalance(newOwningLedger);
            }
        } else {
            Preconditions.checkState(this.map.size() > 0, "The final removal of reference manager should be connected to owning reference manager");
        }
    }

    public abstract @UnknownKeyFor @NonNull @Initialized long getSize();

    protected abstract @UnknownKeyFor @NonNull @Initialized long memoryAddress();

    protected abstract void release0();

    public static interface Factory {
        public @UnknownKeyFor @NonNull @Initialized AllocationManager create(@UnknownKeyFor @NonNull @Initialized BufferAllocator var1, @UnknownKeyFor @NonNull @Initialized long var2);

        public @UnknownKeyFor @NonNull @Initialized ArrowBuf empty();
    }
}

