/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.versionfield;

import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.lucene.search.AutomatonQueries;

class VersionFieldWildcardQuery
extends AutomatonQuery {
    private static final Automaton OPTIONAL_NUMERIC_CHARPREFIX = Operations.optional((Automaton)Operations.concatenate((Automaton)Automata.makeChar((int)1), (Automaton)Automata.makeCharRange((int)128, (int)255)));
    private static final Automaton OPTIONAL_RELEASE_SEPARATOR = Operations.optional((Automaton)Operations.union((Automaton)Automata.makeChar((int)2), (Automaton)Automata.makeChar((int)3)));
    private static final byte WILDCARD_STRING = 42;
    private static final byte WILDCARD_CHAR = 63;

    VersionFieldWildcardQuery(Term term, boolean caseInsensitive) {
        super(term, VersionFieldWildcardQuery.toAutomaton(term, caseInsensitive), true);
    }

    VersionFieldWildcardQuery(Term term, boolean caseInsensitive, MultiTermQuery.RewriteMethod rewriteMethod) {
        super(term, VersionFieldWildcardQuery.toAutomaton(term, caseInsensitive), true, rewriteMethod);
    }

    private static Automaton toAutomaton(Term wildcardquery, boolean caseInsensitive) {
        int length;
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        BytesRef wildcardText = wildcardquery.bytes();
        boolean containsPreReleaseSeparator = false;
        block7: for (int i = 0; i < wildcardText.length; i += length) {
            byte c = wildcardText.bytes[wildcardText.offset + i];
            length = Character.charCount(c);
            switch (c) {
                case 42: {
                    automata.add(Automata.makeAnyString());
                    continue block7;
                }
                case 63: {
                    automata.add(OPTIONAL_NUMERIC_CHARPREFIX);
                    automata.add(OPTIONAL_RELEASE_SEPARATOR);
                    automata.add(Automata.makeAnyChar());
                    continue block7;
                }
                case 45: {
                    automata.add(Operations.optional((Automaton)Automata.makeChar((int)2)));
                    containsPreReleaseSeparator = true;
                    automata.add(Automata.makeChar((int)c));
                    continue block7;
                }
                case 43: {
                    automata.add(Operations.optional((Automaton)Automata.makeChar((int)3)));
                    containsPreReleaseSeparator = true;
                    automata.add(Automata.makeChar((int)c));
                    continue block7;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    boolean firstDigitInGroup = true;
                    if (i > 0 && wildcardText.bytes[wildcardText.offset + i - 1] >= 48 && wildcardText.bytes[wildcardText.offset + i - 1] <= 57) {
                        firstDigitInGroup = false;
                    }
                    if (firstDigitInGroup) {
                        automata.add(OPTIONAL_NUMERIC_CHARPREFIX);
                    }
                    automata.add(Automata.makeChar((int)c));
                    continue block7;
                }
                default: {
                    if (!caseInsensitive) {
                        automata.add(Automata.makeChar((int)c));
                        continue block7;
                    }
                    automata.add(AutomatonQueries.toCaseInsensitiveChar((int)c));
                }
            }
        }
        if (!containsPreReleaseSeparator) {
            automata.add(Operations.optional((Automaton)Automata.makeChar((int)3)));
        }
        return Operations.determinize((Automaton)Operations.concatenate(automata), (int)10000);
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        return buffer.toString();
    }
}

