/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalTopHits;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class TopHitsAggExtractor
implements BucketExtractor {
    static final String NAME = "th";
    private final String name;
    private final DataType fieldDataType;
    private final ZoneId zoneId;

    public TopHitsAggExtractor(String name, DataType fieldDataType, ZoneId zoneId) {
        this.name = name;
        this.fieldDataType = fieldDataType;
        this.zoneId = zoneId;
    }

    TopHitsAggExtractor(StreamInput in) throws IOException {
        this.name = in.readString();
        this.fieldDataType = SqlDataTypes.fromTypeName(in.readString());
        this.zoneId = SqlStreamInput.asSqlStream(in).zoneId();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.fieldDataType.typeName());
    }

    String name() {
        return this.name;
    }

    DataType fieldDataType() {
        return this.fieldDataType;
    }

    ZoneId zoneId() {
        return this.zoneId;
    }

    public String getWriteableName() {
        return NAME;
    }

    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        InternalTopHits agg = (InternalTopHits)bucket.getAggregations().get(this.name);
        if (agg == null) {
            throw new SqlIllegalArgumentException("Cannot find an aggregation named {}", this.name);
        }
        if (agg.getHits().getTotalHits() == null || agg.getHits().getTotalHits().value() == 0L) {
            return null;
        }
        Object value = ((DocumentField)agg.getHits().getAt(0).getDocumentFields().values().iterator().next()).getValue();
        if (this.fieldDataType == DataTypes.DATETIME || this.fieldDataType == SqlDataTypes.DATE) {
            return DateUtils.asDateTimeWithNanos(value.toString()).withZoneSameInstant(this.zoneId());
        }
        if (SqlDataTypes.isTimeBased(this.fieldDataType)) {
            return DateUtils.asTimeOnly(Long.parseLong(value.toString()), this.zoneId);
        }
        if (this.fieldDataType == DataTypes.UNSIGNED_LONG) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                return DataTypeConverter.toUnsignedLong((Number)number);
            }
            throw new SqlIllegalArgumentException("Invalid unsigned_long key returned: {}", value);
        }
        return value;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldDataType, this.zoneId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TopHitsAggExtractor other = (TopHitsAggExtractor)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.fieldDataType, other.fieldDataType) && Objects.equals(this.zoneId, other.zoneId);
    }

    public String toString() {
        return "TopHits>" + this.name + "[" + String.valueOf(this.fieldDataType) + "]@" + String.valueOf(this.zoneId);
    }
}

