/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchResponse;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;

public class RestAckWatchAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_watcher/watch/{id}/_ack"), new RestHandler.Route(RestRequest.Method.PUT, "/_watcher/watch/{id}/_ack"), new RestHandler.Route(RestRequest.Method.POST, "/_watcher/watch/{id}/_ack/{actions}"), new RestHandler.Route(RestRequest.Method.PUT, "/_watcher/watch/{id}/_ack/{actions}"));
    }

    public String getName() {
        return "watcher_ack_watch";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        AckWatchRequest ackWatchRequest = new AckWatchRequest(request.param("id"), new String[0]);
        String[] actions = request.paramAsStringArray("actions", null);
        if (actions != null) {
            ackWatchRequest.setActionIds(actions);
        }
        return channel -> client.execute((ActionType)AckWatchAction.INSTANCE, (ActionRequest)ackWatchRequest, (ActionListener)new RestBuilderListener<AckWatchResponse>(this, channel){

            public RestResponse buildResponse(AckWatchResponse response, XContentBuilder builder) throws Exception {
                return new RestResponse(RestStatus.OK, builder.startObject().field(WatchField.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
            }
        });
    }
}

