/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.health;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.datastreams.lifecycle.DataStreamLifecycleErrorStore;
import org.elasticsearch.datastreams.lifecycle.DataStreamLifecycleService;
import org.elasticsearch.health.node.DataStreamLifecycleHealthInfo;
import org.elasticsearch.health.node.DslErrorInfo;
import org.elasticsearch.health.node.UpdateHealthInfoCacheAction;
import org.elasticsearch.health.node.selection.HealthNode;

public class DataStreamLifecycleHealthInfoPublisher {
    private static final Logger logger = LogManager.getLogger(DataStreamLifecycleHealthInfoPublisher.class);
    public static final Setting<Integer> DATA_STREAM_LIFECYCLE_MAX_ERRORS_TO_PUBLISH_SETTING = Setting.intSetting((String)"data_streams.lifecycle.max_errors_to_publish", (int)500, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final Client client;
    private final ClusterService clusterService;
    private final DataStreamLifecycleErrorStore errorStore;
    private volatile int signallingErrorRetryInterval;
    private volatile int maxNumberOfErrorsToPublish;

    public DataStreamLifecycleHealthInfoPublisher(Settings settings, Client client, ClusterService clusterService, DataStreamLifecycleErrorStore errorStore) {
        this.client = client;
        this.clusterService = clusterService;
        this.errorStore = errorStore;
        this.signallingErrorRetryInterval = (Integer)DataStreamLifecycleService.DATA_STREAM_SIGNALLING_ERROR_RETRY_INTERVAL_SETTING.get(settings);
        this.maxNumberOfErrorsToPublish = (Integer)DATA_STREAM_LIFECYCLE_MAX_ERRORS_TO_PUBLISH_SETTING.get(settings);
    }

    public void init() {
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DataStreamLifecycleService.DATA_STREAM_SIGNALLING_ERROR_RETRY_INTERVAL_SETTING, this::updateSignallingRetryThreshold);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DATA_STREAM_LIFECYCLE_MAX_ERRORS_TO_PUBLISH_SETTING, this::updateNumberOfErrorsToPublish);
    }

    private void updateSignallingRetryThreshold(int newValue) {
        this.signallingErrorRetryInterval = newValue;
    }

    private void updateNumberOfErrorsToPublish(int newValue) {
        this.maxNumberOfErrorsToPublish = newValue;
    }

    public void publishDslErrorEntries(ActionListener<AcknowledgedResponse> actionListener) {
        List<DslErrorInfo> errorEntriesToSignal = this.errorStore.getErrorsInfo(entry -> entry.retryCount() >= this.signallingErrorRetryInterval, this.maxNumberOfErrorsToPublish);
        DiscoveryNode currentHealthNode = HealthNode.findHealthNode((ClusterState)this.clusterService.state());
        if (currentHealthNode != null) {
            String healthNodeId = currentHealthNode.getId();
            logger.trace("reporting [{}] DSL error entries to to health node [{}]", (Object)errorEntriesToSignal.size(), (Object)healthNodeId);
            this.client.execute((ActionType)UpdateHealthInfoCacheAction.INSTANCE, (ActionRequest)new UpdateHealthInfoCacheAction.Request(healthNodeId, new DataStreamLifecycleHealthInfo(errorEntriesToSignal, this.errorStore.getAllIndices().size())), actionListener);
        } else {
            logger.trace("unable to report DSL health because there is no health node in the cluster. will retry on the next DSL run");
        }
    }
}

