/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.put;

import java.util.Optional;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutRepositoryAction
extends AcknowledgedTransportMasterNodeAction<PutRepositoryRequest> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("cluster:admin/repository/put");
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportPutRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, PutRepositoryRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.repositoriesService = repositoriesService;
    }

    @Override
    protected ClusterBlockException checkBlock(PutRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, PutRepositoryRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.repositoriesService.registerRepository(request, listener);
    }

    @Override
    public Optional<String> reservedStateHandlerName() {
        return Optional.of("snapshot_repositories");
    }

    @Override
    public Set<String> modifiedKeys(PutRepositoryRequest request) {
        return Set.of(request.name());
    }
}

