/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.snapshots.SnapshotInfo;

public enum SnapshotSortKey {
    START_TIME("start_time", (Comparator)Comparator.comparingLong(SnapshotInfo::startTime)){

        @Override
        protected String getSortKeyValue(SnapshotInfo snapshotInfo) {
            return Long.toString(snapshotInfo.startTime());
        }

        @Override
        protected Predicate<SnapshotInfo> innerGetAfterPredicate(After after, SortOrder sortOrder) {
            return after.longValuePredicate(SnapshotInfo::startTime, sortOrder);
        }
    }
    ,
    NAME("name", (Comparator)Comparator.comparing(sni -> sni.snapshotId().getName())){

        @Override
        protected String getSortKeyValue(SnapshotInfo snapshotInfo) {
            return snapshotInfo.snapshotId().getName();
        }

        @Override
        protected Predicate<SnapshotInfo> innerGetAfterPredicate(After after, SortOrder sortOrder) {
            String snapshotName = after.snapshotName();
            String repoName = after.repoName();
            return sortOrder == SortOrder.ASC ? info -> SnapshotSortKey.compareName(snapshotName, repoName, info) < 0 : info -> SnapshotSortKey.compareName(snapshotName, repoName, info) > 0;
        }
    }
    ,
    DURATION("duration", (Comparator)Comparator.comparingLong(sni -> sni.endTime() - sni.startTime())){

        @Override
        protected String getSortKeyValue(SnapshotInfo snapshotInfo) {
            return Long.toString(snapshotInfo.endTime() - snapshotInfo.startTime());
        }

        @Override
        protected Predicate<SnapshotInfo> innerGetAfterPredicate(After after, SortOrder sortOrder) {
            return after.longValuePredicate(info -> info.endTime() - info.startTime(), sortOrder);
        }
    }
    ,
    INDICES("index_count", (Comparator)Comparator.comparingInt(sni -> sni.indices().size())){

        @Override
        protected String getSortKeyValue(SnapshotInfo snapshotInfo) {
            return Integer.toString(snapshotInfo.indices().size());
        }

        @Override
        protected Predicate<SnapshotInfo> innerGetAfterPredicate(After after, SortOrder sortOrder) {
            return after.longValuePredicate(info -> info.indices().size(), sortOrder);
        }
    }
    ,
    SHARDS("shard_count", (Comparator)Comparator.comparingInt(SnapshotInfo::totalShards)){

        @Override
        protected String getSortKeyValue(SnapshotInfo snapshotInfo) {
            return Integer.toString(snapshotInfo.totalShards());
        }

        @Override
        protected Predicate<SnapshotInfo> innerGetAfterPredicate(After after, SortOrder sortOrder) {
            return after.longValuePredicate(SnapshotInfo::totalShards, sortOrder);
        }
    }
    ,
    FAILED_SHARDS("failed_shard_count", (Comparator)Comparator.comparingInt(SnapshotInfo::failedShards)){

        @Override
        protected String getSortKeyValue(SnapshotInfo snapshotInfo) {
            return Integer.toString(snapshotInfo.failedShards());
        }

        @Override
        protected Predicate<SnapshotInfo> innerGetAfterPredicate(After after, SortOrder sortOrder) {
            return after.longValuePredicate(SnapshotInfo::failedShards, sortOrder);
        }
    }
    ,
    REPOSITORY("repository", (Comparator)Comparator.comparing(SnapshotInfo::repository)){

        @Override
        protected String getSortKeyValue(SnapshotInfo snapshotInfo) {
            return snapshotInfo.repository();
        }

        @Override
        protected Predicate<SnapshotInfo> innerGetAfterPredicate(After after, SortOrder sortOrder) {
            String snapshotName = after.snapshotName();
            String repoName = after.repoName();
            return sortOrder == SortOrder.ASC ? info -> 7.compareRepositoryName(snapshotName, repoName, info) < 0 : info -> 7.compareRepositoryName(snapshotName, repoName, info) > 0;
        }

        private static int compareRepositoryName(String name, String repoName, SnapshotInfo info) {
            int res = repoName.compareTo(info.repository());
            if (res != 0) {
                return res;
            }
            return name.compareTo(info.snapshotId().getName());
        }
    };

    private final String name;
    private final Comparator<SnapshotInfo> ascendingSnapshotInfoComparator;
    private final Comparator<SnapshotInfo> descendingSnapshotInfoComparator;

    private SnapshotSortKey(String name, Comparator<SnapshotInfo> snapshotInfoComparator) {
        this.name = name;
        this.ascendingSnapshotInfoComparator = snapshotInfoComparator.thenComparing(SnapshotInfo::snapshotId);
        this.descendingSnapshotInfoComparator = this.ascendingSnapshotInfoComparator.reversed();
    }

    public String toString() {
        return this.name;
    }

    public final Comparator<SnapshotInfo> getSnapshotInfoComparator(SortOrder sortOrder) {
        return switch (sortOrder) {
            default -> throw new MatchException(null, null);
            case SortOrder.ASC -> this.ascendingSnapshotInfoComparator;
            case SortOrder.DESC -> this.descendingSnapshotInfoComparator;
        };
    }

    public static After decodeAfterQueryParam(String param) {
        String[] parts = new String(Base64.getUrlDecoder().decode(param), StandardCharsets.UTF_8).split(",");
        if (parts.length != 3) {
            throw new IllegalArgumentException("invalid ?after parameter [" + param + "]");
        }
        return new After(parts[0], parts[1], parts[2]);
    }

    public final String encodeAfterQueryParam(SnapshotInfo snapshotInfo) {
        String rawValue = this.getSortKeyValue(snapshotInfo) + "," + snapshotInfo.repository() + "," + snapshotInfo.snapshotId().getName();
        return Base64.getUrlEncoder().encodeToString(rawValue.getBytes(StandardCharsets.UTF_8));
    }

    protected abstract String getSortKeyValue(SnapshotInfo var1);

    public final Predicate<SnapshotInfo> getAfterPredicate(@Nullable After after, SortOrder sortOrder) {
        return after == null ? Predicates.always() : this.innerGetAfterPredicate(after, sortOrder);
    }

    protected abstract Predicate<SnapshotInfo> innerGetAfterPredicate(After var1, SortOrder var2);

    private static int compareName(String name, String repoName, SnapshotInfo info) {
        int res = name.compareTo(info.snapshotId().getName());
        if (res != 0) {
            return res;
        }
        return repoName.compareTo(info.repository());
    }

    public static SnapshotSortKey of(String name) {
        return switch (name) {
            case "start_time" -> START_TIME;
            case "name" -> NAME;
            case "duration" -> DURATION;
            case "index_count" -> INDICES;
            case "shard_count" -> SHARDS;
            case "failed_shard_count" -> FAILED_SHARDS;
            case "repository" -> REPOSITORY;
            default -> throw new IllegalArgumentException("unknown sort key [" + name + "]");
        };
    }

    public record After(String value, String repoName, String snapshotName) implements Writeable
    {
        After(StreamInput in) throws IOException {
            this(in.readString(), in.readString(), in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.value);
            out.writeString(this.repoName);
            out.writeString(this.snapshotName);
        }

        Predicate<SnapshotInfo> longValuePredicate(ToLongFunction<SnapshotInfo> extractor, SortOrder sortOrder) {
            long after = Long.parseLong(this.value);
            return sortOrder == SortOrder.ASC ? info -> {
                long val = extractor.applyAsLong((SnapshotInfo)info);
                return after < val || after == val && SnapshotSortKey.compareName(this.snapshotName, this.repoName, info) < 0;
            } : info -> {
                long val = extractor.applyAsLong((SnapshotInfo)info);
                return after > val || after == val && SnapshotSortKey.compareName(this.snapshotName, this.repoName, info) > 0;
            };
        }
    }
}

