/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetComponentTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalClusterStateAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetComponentTemplateAction
extends TransportLocalClusterStateAction<GetComponentTemplateAction.Request, GetComponentTemplateAction.Response> {
    private final ClusterSettings clusterSettings;

    @Inject
    public TransportGetComponentTemplateAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters) {
        super("cluster:admin/component_template/get", actionFilters, transportService.getTaskManager(), clusterService, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterSettings = clusterService.getClusterSettings();
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetComponentTemplateAction.Request::new, (request, channel, task) -> this.executeDirect(task, request, new ChannelActionListener(channel)));
    }

    @Override
    protected ClusterBlockException checkBlock(GetComponentTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void localClusterStateOperation(Task task, GetComponentTemplateAction.Request request, ClusterState state, ActionListener<GetComponentTemplateAction.Response> listener) {
        Map<String, ComponentTemplate> results;
        CancellableTask cancellableTask = (CancellableTask)task;
        Map<String, ComponentTemplate> allTemplates = state.metadata().componentTemplates();
        if (request.name() == null) {
            results = allTemplates;
        } else {
            results = new HashMap<String, ComponentTemplate>();
            String name = request.name();
            if (Regex.isSimpleMatchPattern(name)) {
                for (Map.Entry<String, ComponentTemplate> entry : allTemplates.entrySet()) {
                    if (!Regex.simpleMatch(name, entry.getKey())) continue;
                    results.put(entry.getKey(), entry.getValue());
                }
            } else if (allTemplates.containsKey(name)) {
                results.put(name, allTemplates.get(name));
            } else {
                throw new ResourceNotFoundException("component template matching [" + request.name() + "] not found", new Object[0]);
            }
        }
        cancellableTask.ensureNotCancelled();
        if (request.includeDefaults()) {
            listener.onResponse(new GetComponentTemplateAction.Response(results, this.clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING)));
        } else {
            listener.onResponse(new GetComponentTemplateAction.Response(results));
        }
    }
}

