/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.core.TimeValue;

public class AckedBatchedClusterStateUpdateTask
implements ClusterStateTaskListener,
ClusterStateAckListener {
    private final ActionListener<AcknowledgedResponse> listener;
    private final TimeValue ackTimeout;

    public AckedBatchedClusterStateUpdateTask(TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.ackTimeout = ackTimeout;
        this.listener = listener;
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }

    @Override
    public boolean mustAck(DiscoveryNode discoveryNode) {
        return true;
    }

    @Override
    public void onAllNodesAcked() {
        this.listener.onResponse(AcknowledgedResponse.TRUE);
    }

    @Override
    public void onAckFailure(Exception e) {
        this.listener.onResponse(AcknowledgedResponse.FALSE);
    }

    @Override
    public void onAckTimeout() {
        this.listener.onResponse(AcknowledgedResponse.FALSE);
    }

    @Override
    public TimeValue ackTimeout() {
        return this.ackTimeout;
    }
}

