/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;

public interface Compressor {
    public boolean isCompressed(BytesReference var1);

    default public StreamInput threadLocalStreamInput(InputStream in) throws IOException {
        return new InputStreamStreamInput(new BufferedInputStream(this, this.threadLocalInputStream(in), 4096){

            @Override
            public int read() throws IOException {
                if (this.pos >= this.count) {
                    return super.read();
                }
                return this.buf[this.pos++] & 0xFF;
            }
        });
    }

    public InputStream threadLocalInputStream(InputStream var1) throws IOException;

    public OutputStream threadLocalOutputStream(OutputStream var1) throws IOException;

    public BytesReference uncompress(BytesReference var1) throws IOException;

    public BytesReference compress(BytesReference var1) throws IOException;
}

