/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.SuppressForbidden;

public final class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static boolean exists(Path ... files) {
        for (Path file : files) {
            if (!Files.exists(file, new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    public static boolean isHidden(Path path) {
        Path fileName = path.getFileName();
        if (fileName == null) {
            return false;
        }
        return fileName.toString().startsWith(".");
    }

    public static boolean isDesktopServicesStore(Path path) {
        return Constants.MAC_OS_X && Files.isRegularFile(path, new LinkOption[0]) && ".DS_Store".equals(path.getFileName().toString());
    }

    public static Path append(Path base, Path path, int strip) {
        for (Path subPath : path) {
            if (strip-- > 0) continue;
            base = base.resolve(subPath.toString());
        }
        return base;
    }

    public static void deleteSubDirectories(Path ... paths) throws IOException {
        for (Path path : paths) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path subPath : stream) {
                    if (!Files.isDirectory(subPath, new LinkOption[0])) continue;
                    IOUtils.rm((Path[])new Path[]{subPath});
                }
            }
        }
    }

    public static boolean isAccessibleDirectory(Path directory, Logger logger) {
        assert (directory != null && logger != null);
        if (!Files.exists(directory, new LinkOption[0])) {
            logger.debug("[{}] directory does not exist.", (Object)directory.toAbsolutePath());
            return false;
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            logger.debug("[{}] should be a directory but is not.", (Object)directory.toAbsolutePath());
            return false;
        }
        if (!Files.isReadable(directory)) {
            logger.debug("[{}] directory is not readable.", (Object)directory.toAbsolutePath());
            return false;
        }
        return true;
    }

    @SuppressForbidden(reason="Will only open url streams for local files")
    public static InputStream openFileURLStream(URL url) throws IOException {
        String protocol = url.getProtocol();
        if (!"file".equals(protocol) && !"jar".equals(protocol)) {
            throw new IllegalArgumentException("Invalid protocol [" + protocol + "], must be [file] or [jar]");
        }
        if (!Strings.isEmpty(url.getHost())) {
            throw new IllegalArgumentException("URL cannot have host. Found: [" + url.getHost() + "]");
        }
        if (url.getPort() != -1) {
            throw new IllegalArgumentException("URL cannot have port. Found: [" + url.getPort() + "]");
        }
        return url.openStream();
    }

    public static Path[] files(Path from, DirectoryStream.Filter<Path> filter) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(from, filter);){
            Path[] pathArray = FileSystemUtils.toArray(stream);
            return pathArray;
        }
    }

    public static Path[] files(Path directory) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            Path[] pathArray = FileSystemUtils.toArray(stream);
            return pathArray;
        }
    }

    public static Path[] files(Path directory, String glob) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, glob);){
            Path[] pathArray = FileSystemUtils.toArray(stream);
            return pathArray;
        }
    }

    private static Path[] toArray(DirectoryStream<Path> stream) {
        return (Path[])StreamSupport.stream(stream.spliterator(), false).toArray(Path[]::new);
    }
}

