/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.util.ContextDataProvider;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.plugins.internal.LoggingDataProvider;

public class DynamicContextDataProvider
implements ContextDataProvider {
    private static final AtomicReference<List<? extends LoggingDataProvider>> DATA_PROVIDERS = new AtomicReference();
    private final AtomicInteger mapSize = new AtomicInteger(0);

    public static void setDataProviders(List<? extends LoggingDataProvider> dataProviders) {
        DATA_PROVIDERS.compareAndSet(null, List.copyOf(dataProviders));
    }

    public Map<String, String> supplyContextData() {
        List<? extends LoggingDataProvider> providers = DATA_PROVIDERS.get();
        if (providers != null && !providers.isEmpty()) {
            int expectedSize = this.mapSize.get();
            if (expectedSize == 0) {
                expectedSize = 10;
            }
            LinkedHashMap<String, String> data = Maps.newLinkedHashMapWithExpectedSize(expectedSize);
            providers.forEach(p -> p.collectData(data));
            int newMapSize = data.size();
            this.mapSize.updateAndGet(oldSize -> oldSize >= newMapSize ? oldSize : newMapSize);
            return data;
        }
        return Map.of();
    }
}

