/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.query;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.indices.IndicesQueryCache;

public class IndexQueryCache
implements QueryCache {
    private static final Logger logger = LogManager.getLogger(IndexQueryCache.class);
    private final IndicesQueryCache indicesQueryCache;
    protected final Index index;

    public IndexQueryCache(Index index, IndicesQueryCache indicesQueryCache) {
        this.indicesQueryCache = indicesQueryCache;
        this.index = index;
    }

    @Override
    public void close() throws ElasticsearchException {
        this.clear("close");
    }

    @Override
    public void clear(String reason) {
        logger.debug("full cache clear for [{}], reason [{}]", (Object)this.index, (Object)reason);
        this.indicesQueryCache.clearIndex(this.index.getName());
    }

    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        return this.indicesQueryCache.doCache(weight, policy);
    }
}

