/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.shard.ShardId;

public class RecoveryEngineException
extends EngineException {
    private final int phase;

    public RecoveryEngineException(ShardId shardId, int phase, String msg, Throwable cause) {
        super(shardId, "Phase[" + phase + "] " + msg, cause, new Object[0]);
        this.phase = phase;
    }

    public RecoveryEngineException(StreamInput in) throws IOException {
        super(in);
        this.phase = in.readInt();
    }

    @Override
    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        super.writeTo(out, nestedExceptionsWriter);
        out.writeInt(this.phase);
    }

    public int phase() {
        return this.phase;
    }
}

