/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.AbstractSortedNumericDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.HalfFloatValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public abstract class IndexNumericFieldData
implements IndexFieldData<LeafNumericFieldData> {
    public abstract NumericType getNumericType();

    public final SortField sortField(NumericType targetNumericType, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        boolean requiresCustomComparator;
        IndexFieldData.XFieldComparatorSource source = this.comparatorSource(targetNumericType, missingValue, sortMode, nested);
        boolean bl = requiresCustomComparator = nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || targetNumericType != this.getNumericType();
        if (this.sortRequiresCustomComparator() || requiresCustomComparator) {
            SortField sortField = new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
            sortField.setOptimizeSortWithPoints(!requiresCustomComparator && this.isIndexed());
            return sortField;
        }
        SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
        SortedNumericSortField sortField = new SortedNumericSortField(this.getFieldName(), this.getNumericType().sortFieldType, reverse, selectorType);
        sortField.setMissingValue(source.missingObject(missingValue, reverse));
        switch (this.getNumericType().ordinal()) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                sortField.setOptimizeSortWithPoints(this.isIndexed());
                break;
            }
            default: {
                sortField.setOptimizeSortWithPoints(false);
            }
        }
        return sortField;
    }

    protected abstract boolean sortRequiresCustomComparator();

    protected abstract boolean isIndexed();

    @Override
    public final SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        return this.sortField(this.getNumericType(), missingValue, sortMode, nested, reverse);
    }

    public final BucketedSort newBucketedSort(NumericType targetNumericType, BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return this.comparatorSource(targetNumericType, missingValue, sortMode, nested).newBucketedSort(bigArrays, sortOrder, format, bucketSize, extra);
    }

    @Override
    public final BucketedSort newBucketedSort(BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return this.newBucketedSort(this.getNumericType(), bigArrays, missingValue, sortMode, nested, sortOrder, format, bucketSize, extra);
    }

    private IndexFieldData.XFieldComparatorSource comparatorSource(NumericType targetNumericType, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return switch (targetNumericType.ordinal()) {
            case 8 -> new FloatValuesComparatorSource(this, missingValue, sortMode, nested);
            case 7 -> new HalfFloatValuesComparatorSource(this, missingValue, sortMode, nested);
            case 9 -> new DoubleValuesComparatorSource(this, missingValue, sortMode, nested);
            case 5 -> this.dateComparatorSource(missingValue, sortMode, nested);
            case 6 -> this.dateNanosComparatorSource(missingValue, sortMode, nested);
            default -> {
                if (!$assertionsDisabled && targetNumericType.isFloatingPoint()) {
                    throw new AssertionError();
                }
                yield new LongValuesComparatorSource(this, missingValue, sortMode, nested, targetNumericType);
            }
        };
    }

    protected IndexFieldData.XFieldComparatorSource dateComparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, NumericType.DATE);
    }

    protected IndexFieldData.XFieldComparatorSource dateNanosComparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> IndexNumericFieldData.convertNumeric(dvs, DateUtils::toNanoSeconds), NumericType.DATE_NANOSECONDS);
    }

    protected static SortedNumericDocValues convertNumeric(final SortedNumericDocValues values, final LongUnaryOperator converter) {
        return new AbstractSortedNumericDocValues(){

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            public long nextValue() throws IOException {
                return converter.applyAsLong(values.nextValue());
            }

            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public int nextDoc() throws IOException {
                return values.nextDoc();
            }
        };
    }

    public static enum NumericType {
        BOOLEAN(false, SortField.Type.LONG, CoreValuesSourceType.BOOLEAN),
        BYTE(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        SHORT(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        INT(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        LONG(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        DATE(false, SortField.Type.LONG, CoreValuesSourceType.DATE),
        DATE_NANOSECONDS(false, SortField.Type.LONG, CoreValuesSourceType.DATE),
        HALF_FLOAT(true, SortField.Type.FLOAT, CoreValuesSourceType.NUMERIC),
        FLOAT(true, SortField.Type.FLOAT, CoreValuesSourceType.NUMERIC),
        DOUBLE(true, SortField.Type.DOUBLE, CoreValuesSourceType.NUMERIC);

        private final boolean floatingPoint;
        private final ValuesSourceType valuesSourceType;
        private final SortField.Type sortFieldType;

        private NumericType(boolean floatingPoint, SortField.Type sortFieldType, ValuesSourceType valuesSourceType) {
            this.floatingPoint = floatingPoint;
            this.sortFieldType = sortFieldType;
            this.valuesSourceType = valuesSourceType;
        }

        public final boolean isFloatingPoint() {
            return this.floatingPoint;
        }

        public final ValuesSourceType getValuesSourceType() {
            return this.valuesSourceType;
        }
    }
}

