/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class Mapping
implements ToXContentFragment {
    public static final Mapping EMPTY = new Mapping(new RootObjectMapper.Builder("_doc", ObjectMapper.Defaults.SUBOBJECTS).build(MapperBuilderContext.root(false, false)), new MetadataFieldMapper[0], null);
    private final RootObjectMapper root;
    private final Map<String, Object> meta;
    private final MetadataFieldMapper[] metadataMappers;
    private final Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappersMap;
    private final Map<String, MetadataFieldMapper> metadataMappersByName;

    public Mapping(RootObjectMapper rootObjectMapper, MetadataFieldMapper[] metadataMappers, Map<String, Object> meta) {
        this.metadataMappers = metadataMappers;
        Map.Entry[] metadataMappersMap = new Map.Entry[metadataMappers.length];
        Map.Entry[] metadataMappersByName = new Map.Entry[metadataMappers.length];
        for (int i = 0; i < metadataMappers.length; ++i) {
            MetadataFieldMapper metadataMapper = metadataMappers[i];
            metadataMappersMap[i] = Map.entry(metadataMapper.getClass(), metadataMapper);
            metadataMappersByName[i] = Map.entry(metadataMapper.fullPath(), metadataMapper);
        }
        this.root = rootObjectMapper;
        Arrays.sort(metadataMappers, Comparator.comparing(Mapper::fullPath));
        this.metadataMappersMap = Map.ofEntries(metadataMappersMap);
        this.metadataMappersByName = Map.ofEntries(metadataMappersByName);
        this.meta = meta;
    }

    public CompressedXContent toCompressedXContent() {
        try {
            return new CompressedXContent((ToXContent)this);
        }
        catch (Exception e) {
            throw new ElasticsearchGenerationException("failed to serialize source for type [" + this.root.fullPath() + "]", e);
        }
    }

    public RootObjectMapper getRoot() {
        return this.root;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    MetadataFieldMapper[] getSortedMetadataMappers() {
        return this.metadataMappers;
    }

    Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> getMetadataMappersMap() {
        return this.metadataMappersMap;
    }

    public <T extends MetadataFieldMapper> T getMetadataMapperByClass(Class<T> clazz) {
        return (T)this.metadataMappersMap.get(clazz);
    }

    public MetadataFieldMapper getMetadataMapperByName(String mapperName) {
        return this.metadataMappersByName.get(mapperName);
    }

    void validate(MappingLookup mappers) {
        for (MetadataFieldMapper metadataFieldMapper : this.metadataMappers) {
            metadataFieldMapper.validate(mappers);
        }
        this.root.validate(mappers);
    }

    Mapping mappingUpdate(RootObjectMapper rootObjectMapper) {
        return new Mapping(rootObjectMapper, this.metadataMappers, this.meta);
    }

    private boolean isSourceSynthetic() {
        SourceFieldMapper sfm = (SourceFieldMapper)this.metadataMappersByName.get("_source");
        return sfm != null && sfm.isSynthetic();
    }

    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader(@Nullable SourceFilter filter) {
        List<Mapper> mappers = Stream.concat(Stream.of(this.metadataMappers), this.root.mappers.values().stream()).collect(Collectors.toList());
        return this.root.syntheticFieldLoader(filter, mappers, false);
    }

    Mapping merge(Mapping mergeWith, MapperService.MergeReason reason, long newFieldsBudget) {
        Map<String, Object> mergedMeta;
        MapperMergeContext mergeContext = MapperMergeContext.root(this.isSourceSynthetic(), false, reason, newFieldsBudget);
        RootObjectMapper mergedRoot = this.root.merge(mergeWith.root, mergeContext);
        HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> mergedMetadataMappers = new HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>(this.metadataMappersMap);
        for (MetadataFieldMapper metaMergeWith : mergeWith.metadataMappers) {
            MetadataFieldMapper mergeInto = (MetadataFieldMapper)mergedMetadataMappers.get(metaMergeWith.getClass());
            MetadataFieldMapper merged = mergeInto == null || reason == MapperService.MergeReason.INDEX_TEMPLATE ? metaMergeWith : (MetadataFieldMapper)mergeInto.merge(metaMergeWith, mergeContext);
            mergedMetadataMappers.put(merged.getClass(), merged);
        }
        if (mergeWith.meta == null) {
            mergedMeta = this.meta;
        } else if (this.meta == null || reason != MapperService.MergeReason.INDEX_TEMPLATE) {
            mergedMeta = mergeWith.meta;
        } else {
            mergedMeta = new HashMap<String, Object>(mergeWith.meta);
            XContentHelper.mergeDefaults(mergedMeta, this.meta);
        }
        return new Mapping(mergedRoot, mergedMetadataMappers.values().toArray(new MetadataFieldMapper[0]), mergedMeta);
    }

    public Mapping withFieldsBudget(long fieldsBudget) {
        MapperMergeContext mergeContext = MapperMergeContext.root(this.isSourceSynthetic(), false, MapperService.MergeReason.MAPPING_RECOVERY, fieldsBudget);
        RootObjectMapper shallowRoot = this.root.withoutMappers();
        return new Mapping(shallowRoot.merge(this.root, mergeContext), this.metadataMappers, this.meta);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.root.toXContent(builder, params, (b, params1) -> {
            if (this.meta != null) {
                b.field("_meta", this.meta);
            }
            for (MetadataFieldMapper mapper : this.metadataMappers) {
                mapper.toXContent(b, params1);
            }
            return b;
        });
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

