/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.QueryBuilder;
import org.apache.lucene.util.graph.GraphTokenStreamFiniteStrings;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.SpanBooleanQueryRewriteWithMaxClause;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.PlaceHolderFieldMapper;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.ZeroTermsQueryOption;
import org.elasticsearch.lucene.analysis.miscellaneous.DisableGraphAttribute;

public class MatchQueryParser {
    public static final int DEFAULT_PHRASE_SLOP = 0;
    public static final boolean DEFAULT_LENIENCY = false;
    public static final ZeroTermsQueryOption DEFAULT_ZERO_TERMS_QUERY = ZeroTermsQueryOption.NONE;
    protected final SearchExecutionContext context;
    protected Analyzer analyzer;
    protected BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    protected boolean enablePositionIncrements = true;
    protected int phraseSlop = 0;
    protected Fuzziness fuzziness = null;
    protected int fuzzyPrefixLength = 0;
    protected int maxExpansions = 50;
    protected SpanMultiTermQueryWrapper.SpanRewriteMethod spanRewriteMethod = new SpanBooleanQueryRewriteWithMaxClause(50, false);
    protected boolean transpositions = true;
    protected MultiTermQuery.RewriteMethod fuzzyRewriteMethod;
    protected boolean lenient = false;
    protected ZeroTermsQueryOption zeroTermsQuery = DEFAULT_ZERO_TERMS_QUERY;
    protected boolean autoGenerateSynonymsPhraseQuery = true;

    public MatchQueryParser(SearchExecutionContext context) {
        this.context = context;
    }

    public void setAnalyzer(String analyzerName) {
        this.analyzer = this.context.getIndexAnalyzers().get(analyzerName);
        if (this.analyzer == null) {
            throw new IllegalArgumentException("No analyzer found for [" + analyzerName + "]");
        }
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setOccur(BooleanClause.Occur occur) {
        this.occur = occur;
    }

    public void setEnablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void setFuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
        this.spanRewriteMethod = new SpanBooleanQueryRewriteWithMaxClause(maxExpansions, false);
    }

    public void setTranspositions(boolean transpositions) {
        this.transpositions = transpositions;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setZeroTermsQuery(ZeroTermsQueryOption zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
    }

    public void setAutoGenerateSynonymsPhraseQuery(boolean enabled) {
        this.autoGenerateSynonymsPhraseQuery = enabled;
    }

    public Query parse(Type type, String fieldName, Object value) throws IOException {
        MappedFieldType fieldType = this.context.getFieldType(fieldName);
        if (fieldType == null) {
            return Queries.newUnmappedFieldQuery(fieldName);
        }
        if (fieldType.getTextSearchInfo() == TextSearchInfo.NONE) {
            IllegalArgumentException iae = fieldType instanceof PlaceHolderFieldMapper.PlaceHolderFieldType ? new IllegalArgumentException("Field [" + fieldType.name() + "] of type [" + fieldType.typeName() + "] in legacy index does not support " + type.getQueryName() + " queries") : new IllegalArgumentException("Field [" + fieldType.name() + "] of type [" + fieldType.typeName() + "] does not support " + type.getQueryName() + " queries");
            if (this.lenient) {
                return Queries.newLenientFieldQuery(fieldName, iae);
            }
            throw iae;
        }
        Analyzer analyzer = this.getAnalyzer(fieldType, type == Type.PHRASE || type == Type.PHRASE_PREFIX);
        assert (analyzer != null);
        MatchQueryBuilder builder = new MatchQueryBuilder(analyzer, fieldType, this.enablePositionIncrements, this.autoGenerateSynonymsPhraseQuery);
        String resolvedFieldName = fieldType.name();
        String stringValue = value.toString();
        if (analyzer == Lucene.KEYWORD_ANALYZER && type != Type.PHRASE_PREFIX) {
            Term term = new Term(resolvedFieldName, stringValue);
            if (type == Type.BOOLEAN_PREFIX && (fieldType instanceof TextFieldMapper.TextFieldType || fieldType instanceof KeywordFieldMapper.KeywordFieldType)) {
                return builder.newPrefixQuery(term);
            }
            return builder.newTermQuery(term, 1.0f);
        }
        Query query = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> builder.createBooleanQuery(resolvedFieldName, stringValue, this.occur);
            case 3 -> builder.createBooleanPrefixQuery(resolvedFieldName, stringValue, this.occur);
            case 1 -> builder.createPhraseQuery(resolvedFieldName, stringValue, this.phraseSlop);
            case 2 -> builder.createPhrasePrefixQuery(resolvedFieldName, stringValue, this.phraseSlop);
        };
        return query == null ? this.zeroTermsQuery.asQuery() : query;
    }

    protected Analyzer getAnalyzer(MappedFieldType fieldType, boolean quoted) {
        TextSearchInfo tsi = fieldType.getTextSearchInfo();
        assert (tsi != TextSearchInfo.NONE);
        if (this.analyzer == null) {
            return quoted ? tsi.searchQuoteAnalyzer() : tsi.searchAnalyzer();
        }
        return this.analyzer;
    }

    public static enum Type implements Writeable
    {
        BOOLEAN(0, "match"),
        PHRASE(1, "match_phrase"),
        PHRASE_PREFIX(2, "match_phrase_prefix"),
        BOOLEAN_PREFIX(3, "match_bool_prefix");

        private final int ordinal;
        private final String queryName;

        private Type(int ordinal, String queryName) {
            this.ordinal = ordinal;
            this.queryName = queryName;
        }

        public static Type readFromStream(StreamInput in) throws IOException {
            int ord = in.readVInt();
            for (Type type : Type.values()) {
                if (type.ordinal != ord) continue;
                return type;
            }
            throw new ElasticsearchException("unknown serialized type [" + ord + "]", new Object[0]);
        }

        public String getQueryName() {
            return this.queryName;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal);
        }
    }

    class MatchQueryBuilder
    extends QueryBuilder {
        private final MappedFieldType fieldType;

        MatchQueryBuilder(Analyzer analyzer, MappedFieldType fieldType, boolean enablePositionIncrements, boolean autoGenerateSynonymsPhraseQuery) {
            super(analyzer);
            this.fieldType = fieldType;
            this.setEnablePositionIncrements(enablePositionIncrements);
            if (fieldType.getTextSearchInfo().hasPositions()) {
                this.setAutoGenerateMultiTermSynonymsPhraseQuery(autoGenerateSynonymsPhraseQuery);
            } else {
                this.setAutoGenerateMultiTermSynonymsPhraseQuery(false);
            }
        }

        protected Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int slop) {
            assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
            Type type = quoted ? Type.PHRASE : Type.BOOLEAN;
            return this.createQuery(field, queryText, type, operator, slop);
        }

        protected Query createPhrasePrefixQuery(String field, String queryText, int slop) {
            return this.createQuery(field, queryText, Type.PHRASE_PREFIX, MatchQueryParser.this.occur, slop);
        }

        protected Query createBooleanPrefixQuery(String field, String queryText, BooleanClause.Occur occur) {
            return this.createQuery(field, queryText, Type.BOOLEAN_PREFIX, occur, 0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Query createFieldQuery(TokenStream source, Type type, BooleanClause.Occur operator, String field, int phraseSlop) {
            assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
            try (CachingTokenFilter stream = new CachingTokenFilter(source);){
                TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
                PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
                PositionLengthAttribute posLenAtt = (PositionLengthAttribute)stream.addAttribute(PositionLengthAttribute.class);
                if (termAtt == null) {
                    Query query = null;
                    return query;
                }
                int numTokens = 0;
                int positionCount = 0;
                boolean hasSynonyms = false;
                boolean isGraph = false;
                stream.reset();
                while (stream.incrementToken()) {
                    ++numTokens;
                    int positionIncrement = posIncAtt.getPositionIncrement();
                    if (positionIncrement != 0) {
                        positionCount += positionIncrement;
                    } else {
                        hasSynonyms = true;
                    }
                    int positionLength = posLenAtt.getPositionLength();
                    if (!this.enableGraphQueries || positionLength <= 1) continue;
                    isGraph = true;
                }
                if (numTokens == 0) {
                    Query query = null;
                    return query;
                }
                if (numTokens == 1) {
                    if (type == Type.PHRASE_PREFIX) {
                        Query query = this.analyzePhrasePrefix(field, (TokenStream)stream, phraseSlop, positionCount);
                        return query;
                    }
                    Query query = this.analyzeTerm(field, (TokenStream)stream, type == Type.BOOLEAN_PREFIX);
                    return query;
                }
                if (isGraph) {
                    if (type == Type.PHRASE || type == Type.PHRASE_PREFIX) {
                        Query query = this.analyzeGraphPhrase((TokenStream)stream, field, type, phraseSlop);
                        return query;
                    }
                    Query query = this.analyzeGraphBoolean(field, (TokenStream)stream, operator, type == Type.BOOLEAN_PREFIX);
                    return query;
                }
                if (type == Type.PHRASE && positionCount > 1) {
                    if (hasSynonyms) {
                        Query query = this.analyzeMultiPhrase(field, (TokenStream)stream, phraseSlop);
                        return query;
                    }
                    Query query = this.analyzePhrase(field, (TokenStream)stream, phraseSlop);
                    return query;
                }
                if (type == Type.PHRASE_PREFIX) {
                    Query query = this.analyzePhrasePrefix(field, (TokenStream)stream, phraseSlop, positionCount);
                    return query;
                }
                if (positionCount == 1) {
                    Query query = this.analyzeBoolean(field, (TokenStream)stream);
                    return query;
                }
                Query query = this.analyzeMultiBoolean(field, (TokenStream)stream, operator, type == Type.BOOLEAN_PREFIX);
                return query;
            }
            catch (IOException e) {
                throw new RuntimeException("Error analyzing query text", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        private Query createQuery(String field, String queryText, Type type, BooleanClause.Occur operator, int phraseSlop) {
            try (TokenStream source = this.analyzer.tokenStream(field, queryText);){
                Query query;
                if (source.hasAttribute(DisableGraphAttribute.class)) {
                    this.setEnableGraphQueries(false);
                }
                try {
                    query = this.createFieldQuery(source, type, operator, field, phraseSlop);
                }
                catch (Throwable throwable) {
                    this.setEnableGraphQueries(true);
                    throw throwable;
                }
                this.setEnableGraphQueries(true);
                return query;
            }
            catch (IOException e) {
                throw new RuntimeException("Error analyzing query text", e);
            }
        }

        private SpanQuery newSpanQuery(Term[] terms, boolean isPrefix) {
            if (terms.length == 1) {
                return isPrefix ? this.fieldType.spanPrefixQuery(terms[0].text(), MatchQueryParser.this.spanRewriteMethod, MatchQueryParser.this.context) : new SpanTermQuery(terms[0]);
            }
            SpanQuery[] spanQueries = new SpanQuery[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                spanQueries[i] = isPrefix ? this.fieldType.spanPrefixQuery(terms[i].text(), MatchQueryParser.this.spanRewriteMethod, MatchQueryParser.this.context) : new SpanTermQuery(terms[i]);
            }
            return new SpanOrQuery(spanQueries);
        }

        private SpanQuery createSpanQuery(TokenStream in, String field, boolean isPrefix) throws IOException {
            SpanNearQuery query;
            SpanQuery[] clauses;
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)in.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)in.getAttribute(PositionIncrementAttribute.class);
            if (termAtt == null) {
                return null;
            }
            SpanNearQuery.Builder builder = new SpanNearQuery.Builder(field, true);
            Term lastTerm = null;
            while (in.incrementToken()) {
                if (posIncAtt.getPositionIncrement() > 1) {
                    builder.addGap(posIncAtt.getPositionIncrement() - 1);
                }
                if (lastTerm != null) {
                    builder.addClause((SpanQuery)new SpanTermQuery(lastTerm));
                }
                lastTerm = new Term(field, termAtt.getBytesRef());
            }
            if (lastTerm != null) {
                SpanTermQuery spanQuery = isPrefix ? this.fieldType.spanPrefixQuery(lastTerm.text(), MatchQueryParser.this.spanRewriteMethod, MatchQueryParser.this.context) : new SpanTermQuery(lastTerm);
                builder.addClause((SpanQuery)spanQuery);
            }
            if ((clauses = (query = builder.build()).getClauses()).length == 1) {
                return clauses[0];
            }
            return query;
        }

        protected Query newTermQuery(Term term, float boost) {
            Supplier<Query> querySupplier = MatchQueryParser.this.fuzziness != null ? () -> this.fieldType.fuzzyQuery(term.text(), MatchQueryParser.this.fuzziness, MatchQueryParser.this.fuzzyPrefixLength, MatchQueryParser.this.maxExpansions, MatchQueryParser.this.transpositions, MatchQueryParser.this.context, MatchQueryParser.this.fuzzyRewriteMethod) : () -> this.fieldType.termQuery(term.bytes(), MatchQueryParser.this.context);
            try {
                return querySupplier.get();
            }
            catch (RuntimeException e) {
                if (MatchQueryParser.this.lenient) {
                    return Queries.newLenientFieldQuery(this.fieldType.name(), e);
                }
                throw e;
            }
        }

        protected Query newPrefixQuery(Term term) {
            try {
                return this.fieldType.prefixQuery(term.text(), null, MatchQueryParser.this.context);
            }
            catch (RuntimeException e) {
                if (MatchQueryParser.this.lenient) {
                    return Queries.newLenientFieldQuery(term.field(), e);
                }
                throw e;
            }
        }

        private Query analyzeTerm(String field, TokenStream stream, boolean isPrefix) throws IOException {
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
            stream.reset();
            if (!stream.incrementToken()) {
                throw new AssertionError();
            }
            Term term = new Term(field, termAtt.getBytesRef());
            int lastOffset = offsetAtt.endOffset();
            stream.end();
            return isPrefix && lastOffset == offsetAtt.endOffset() ? this.newPrefixQuery(term) : this.newTermQuery(term, 1.0f);
        }

        private void add(BooleanQuery.Builder q, String field, List<Term> current, BooleanClause.Occur operator, boolean isPrefix) {
            if (current.isEmpty()) {
                return;
            }
            if (current.size() == 1) {
                if (isPrefix) {
                    q.add(this.newPrefixQuery(current.get(0)), operator);
                } else {
                    q.add(this.newTermQuery(current.get(0), 1.0f), operator);
                }
            } else {
                QueryBuilder.TermAndBoost[] termAndBoosts = (QueryBuilder.TermAndBoost[])current.stream().map(t -> new QueryBuilder.TermAndBoost(t.bytes(), 1.0f)).toArray(QueryBuilder.TermAndBoost[]::new);
                q.add(this.newSynonymQuery(field, termAndBoosts), operator);
            }
        }

        private Query analyzeMultiBoolean(String field, TokenStream stream, BooleanClause.Occur operator, boolean isPrefix) throws IOException {
            BooleanQuery.Builder q = this.newBooleanQuery();
            ArrayList<Term> currentQuery = new ArrayList<Term>();
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
            stream.reset();
            int lastOffset = 0;
            while (stream.incrementToken()) {
                if (posIncrAtt.getPositionIncrement() != 0) {
                    this.add(q, field, currentQuery, operator, false);
                    currentQuery.clear();
                }
                currentQuery.add(new Term(field, termAtt.getBytesRef()));
                lastOffset = offsetAtt.endOffset();
            }
            stream.end();
            this.add(q, field, currentQuery, operator, isPrefix && lastOffset == offsetAtt.endOffset());
            return q.build();
        }

        protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
            try {
                return this.fieldType.phraseQuery(stream, slop, this.enablePositionIncrements, MatchQueryParser.this.context);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                if (MatchQueryParser.this.lenient) {
                    return Queries.newLenientFieldQuery(field, e);
                }
                throw e;
            }
        }

        protected Query analyzeMultiPhrase(String field, TokenStream stream, int slop) throws IOException {
            try {
                return this.fieldType.multiPhraseQuery(stream, slop, this.enablePositionIncrements, MatchQueryParser.this.context);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                if (MatchQueryParser.this.lenient) {
                    return Queries.newLenientFieldQuery(field, e);
                }
                throw e;
            }
        }

        private Query analyzePhrasePrefix(String field, TokenStream stream, int slop, int positionCount) throws IOException {
            try {
                return this.fieldType.phrasePrefixQuery(stream, slop, MatchQueryParser.this.maxExpansions, MatchQueryParser.this.context);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                if (MatchQueryParser.this.lenient) {
                    return Queries.newLenientFieldQuery(field, e);
                }
                throw e;
            }
        }

        private Query analyzeGraphBoolean(final String field, TokenStream source, BooleanClause.Occur operator, boolean isPrefix) throws IOException {
            source.reset();
            GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            int[] articulationPoints = graph.articulationPoints();
            int lastState = 0;
            for (int i = 0; i <= articulationPoints.length; ++i) {
                Query queryPos;
                boolean usePrefix;
                int start = lastState;
                int end = -1;
                if (i < articulationPoints.length) {
                    end = articulationPoints[i];
                }
                lastState = end;
                boolean bl = usePrefix = isPrefix && end == -1;
                if (graph.hasSidePath(start)) {
                    final Iterator it = graph.getFiniteStrings(start, end);
                    Iterator<Query> queries = new Iterator<Query>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public Query next() {
                            TokenStream ts = (TokenStream)it.next();
                            Type type = MatchQueryBuilder.this.getAutoGenerateMultiTermSynonymsPhraseQuery() ? (usePrefix ? Type.PHRASE_PREFIX : Type.PHRASE) : Type.BOOLEAN;
                            return MatchQueryBuilder.this.createFieldQuery(ts, type, BooleanClause.Occur.MUST, field, 0);
                        }
                    };
                    queryPos = this.newGraphSynonymQuery(queries);
                } else {
                    Term[] terms = graph.getTerms(field, start);
                    assert (terms.length > 0);
                    if (terms.length == 1) {
                        queryPos = usePrefix ? this.newPrefixQuery(terms[0]) : this.newTermQuery(terms[0], 1.0f);
                    } else {
                        QueryBuilder.TermAndBoost[] termAndBoosts = (QueryBuilder.TermAndBoost[])Arrays.stream(terms).map(t -> new QueryBuilder.TermAndBoost(t.bytes(), 1.0f)).toArray(QueryBuilder.TermAndBoost[]::new);
                        queryPos = this.newSynonymQuery(field, termAndBoosts);
                    }
                }
                if (queryPos == null) continue;
                builder.add(queryPos, operator);
            }
            return builder.build();
        }

        private Query analyzeGraphPhrase(TokenStream source, String field, Type type, int slop) throws IOException {
            assert (type == Type.PHRASE_PREFIX || type == Type.PHRASE);
            source.reset();
            GraphTokenStreamFiniteStrings graph = new GraphTokenStreamFiniteStrings(source);
            if (MatchQueryParser.this.phraseSlop > 0) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                Iterator it = graph.getFiniteStrings();
                while (it.hasNext()) {
                    Query query = this.createFieldQuery((TokenStream)it.next(), type, BooleanClause.Occur.MUST, field, slop);
                    if (query == null) continue;
                    builder.add(query, BooleanClause.Occur.SHOULD);
                }
                return builder.build();
            }
            ArrayList<SpanQuery> clauses = new ArrayList<SpanQuery>();
            int[] articulationPoints = graph.articulationPoints();
            int lastState = 0;
            int maxClauseCount = IndexSearcher.getMaxClauseCount();
            for (int i = 0; i <= articulationPoints.length; ++i) {
                Object queryPos;
                boolean usePrefix;
                int start = lastState;
                int end = -1;
                if (i < articulationPoints.length) {
                    end = articulationPoints[i];
                }
                lastState = end;
                boolean bl = usePrefix = end == -1 && type == Type.PHRASE_PREFIX;
                if (graph.hasSidePath(start)) {
                    ArrayList<SpanQuery> queries = new ArrayList<SpanQuery>();
                    Iterator it = graph.getFiniteStrings(start, end);
                    while (it.hasNext()) {
                        TokenStream ts = (TokenStream)it.next();
                        SpanQuery q = this.createSpanQuery(ts, field, usePrefix);
                        if (q == null) continue;
                        if (queries.size() >= maxClauseCount) {
                            throw new IndexSearcher.TooManyClauses();
                        }
                        queries.add(q);
                    }
                    queryPos = queries.size() > 0 ? new SpanOrQuery(queries.toArray(new SpanQuery[0])) : null;
                } else {
                    Term[] terms = graph.getTerms(field, start);
                    assert (terms.length > 0);
                    if (terms.length >= maxClauseCount) {
                        throw new IndexSearcher.TooManyClauses();
                    }
                    queryPos = this.newSpanQuery(terms, usePrefix);
                }
                if (queryPos == null) continue;
                if (clauses.size() >= maxClauseCount) {
                    throw new IndexSearcher.TooManyClauses();
                }
                clauses.add((SpanQuery)queryPos);
            }
            if (clauses.isEmpty()) {
                return null;
            }
            if (clauses.size() == 1) {
                return (Query)clauses.get(0);
            }
            return new SpanNearQuery(clauses.toArray(new SpanQuery[0]), 0, true);
        }
    }
}

