/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceExtension;

public class InferenceServiceRegistry
implements Closeable {
    private final Map<String, InferenceService> services;
    private final List<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();

    public InferenceServiceRegistry(List<InferenceServiceExtension> inferenceServicePlugins, InferenceServiceExtension.InferenceServiceFactoryContext factoryContext) {
        this.services = inferenceServicePlugins.stream().flatMap(r -> r.getInferenceServiceFactories().stream()).map(factory -> factory.create(factoryContext)).collect(Collectors.toMap(InferenceService::name, Function.identity()));
    }

    public void init(Client client) {
        this.services.values().forEach(s -> s.init(client));
    }

    public void onNodeStarted() {
        for (InferenceService service : this.services.values()) {
            try {
                service.onNodeStarted();
            }
            catch (Exception exception) {}
        }
    }

    public Map<String, InferenceService> getServices() {
        return this.services;
    }

    public Optional<InferenceService> getService(String serviceName) {
        if ("elser".equals(serviceName)) {
            return Optional.ofNullable(this.services.get("elasticsearch"));
        }
        return Optional.ofNullable(this.services.get(serviceName));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWriteables;
    }

    @Override
    public void close() throws IOException {
        for (InferenceService service : this.services.values()) {
            service.close();
        }
    }
}

