/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.node.capabilities.NodesCapabilitiesRequest;
import org.elasticsearch.action.admin.cluster.node.capabilities.NodesCapabilitiesResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestActions;

@ServerlessScope(value=Scope.INTERNAL)
public class RestNodesCapabilitiesAction
extends BaseRestHandler {
    private static final Set<String> SUPPORTED_QUERY_PARAMETERS = Set.of("timeout", "method", "path", "parameters", "capabilities", "local_only");

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_capabilities"));
    }

    @Override
    public Set<String> supportedQueryParameters() {
        return SUPPORTED_QUERY_PARAMETERS;
    }

    @Override
    public String getName() {
        return "nodes_capabilities_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        NodesCapabilitiesRequest requestNodes = request.paramAsBoolean("local_only", false) ? new NodesCapabilitiesRequest(client.getLocalNodeId()) : new NodesCapabilitiesRequest();
        String path = URLDecoder.decode(request.param("path", "/"), StandardCharsets.UTF_8);
        requestNodes.setTimeout(RestUtils.getTimeout(request));
        NodesCapabilitiesRequest r = requestNodes.method(RestRequest.Method.valueOf(request.param("method", "GET"))).path(path).parameters(request.paramAsStringArray("parameters", Strings.EMPTY_ARRAY)).capabilities(request.paramAsStringArray("capabilities", Strings.EMPTY_ARRAY));
        if (request.hasExplicitRestApiVersion()) {
            r.restApiVersion(request.getRestApiVersion());
        }
        return channel -> client.admin().cluster().nodesCapabilities(r, new RestActions.NodesResponseRestListener<NodesCapabilitiesResponse>((RestChannel)channel));
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

