/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.DenseVectorScriptDocValues;
import org.elasticsearch.index.mapper.vectors.VectorEncoderDecoder;
import org.elasticsearch.script.field.vectors.BinaryDenseVector;
import org.elasticsearch.script.field.vectors.DenseVector;
import org.elasticsearch.script.field.vectors.DenseVectorDocValuesField;

public class BinaryDenseVectorDocValuesField
extends DenseVectorDocValuesField {
    private final BinaryDocValues input;
    private final float[] vectorValue;
    private final IndexVersion indexVersion;
    private boolean decoded;
    private final int dims;
    private BytesRef value;

    public BinaryDenseVectorDocValuesField(BinaryDocValues input, String name, DenseVectorFieldMapper.ElementType elementType, int dims, IndexVersion indexVersion) {
        super(name, elementType);
        this.input = input;
        this.indexVersion = indexVersion;
        this.dims = dims;
        this.vectorValue = new float[dims];
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        this.decoded = false;
        this.value = this.input.advanceExact(docId) ? this.input.binaryValue() : null;
    }

    @Override
    public DenseVectorScriptDocValues toScriptDocValues() {
        return new DenseVectorScriptDocValues(this, this.dims);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    public DenseVector get() {
        if (this.isEmpty()) {
            return DenseVector.EMPTY;
        }
        this.decodeVectorIfNecessary();
        return new BinaryDenseVector(this.vectorValue, this.value, this.dims, this.indexVersion);
    }

    @Override
    public DenseVector get(DenseVector defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        this.decodeVectorIfNecessary();
        return new BinaryDenseVector(this.vectorValue, this.value, this.dims, this.indexVersion);
    }

    @Override
    public DenseVector getInternal() {
        return this.get(null);
    }

    private void decodeVectorIfNecessary() {
        if (!this.decoded && this.value != null) {
            VectorEncoderDecoder.decodeDenseVector(this.indexVersion, this.value, this.vectorValue);
            this.decoded = true;
        }
    }
}

