/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractInternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.xcontent.XContentBuilder;

public class LongTerms
extends InternalMappedTerms<LongTerms, Bucket> {
    public static final String NAME = "lterms";

    public LongTerms(String name, BucketOrder reduceOrder, BucketOrder order, int requiredSize, long minDocCount, Map<String, Object> metadata, DocValueFormat format, int shardSize, boolean showTermDocCountError, long otherDocCount, List<Bucket> buckets, Long docCountError) {
        super(name, reduceOrder, order, requiredSize, minDocCount, metadata, format, shardSize, showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    public LongTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public LongTerms create(List<Bucket> buckets) {
        return new LongTerms(this.name, this.reduceOrder, this.order, this.requiredSize, this.minDocCount, (Map<String, Object>)this.metadata, this.format, this.shardSize, this.showTermDocCountError, this.otherDocCount, buckets, this.docCountError);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.term, prototype.docCount, aggregations, this.showTermDocCountError, prototype.getDocCountError(), prototype.format);
    }

    @Override
    protected LongTerms create(String name, List<Bucket> buckets, BucketOrder reduceOrder, long docCountError, long otherDocCount) {
        return new LongTerms(name, reduceOrder, this.order, this.requiredSize, this.minDocCount, this.getMetadata(), this.format, this.shardSize, this.showTermDocCountError, otherDocCount, buckets, (Long)docCountError);
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        final Predicate<DocValueFormat> needsPromoting = this.format == DocValueFormat.RAW ? docFormat -> docFormat == DocValueFormat.UNSIGNED_LONG_SHIFTED : (this.format == DocValueFormat.UNSIGNED_LONG_SHIFTED ? docFormat -> docFormat == DocValueFormat.RAW : Predicates.never());
        return new AggregatorReducer(){
            private List<InternalAggregation> aggregations;
            private boolean isPromotedToDouble;
            {
                this.aggregations = new ArrayList<InternalAggregation>(size);
                this.isPromotedToDouble = false;
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                if (aggregation instanceof DoubleTerms) {
                    DoubleTerms doubleTerms = (DoubleTerms)aggregation;
                    if (!this.isPromotedToDouble) {
                        this.promoteToDouble(this.aggregations);
                        this.isPromotedToDouble = true;
                    }
                    this.aggregations.add(doubleTerms);
                } else if (aggregation instanceof LongTerms) {
                    LongTerms longTerms = (LongTerms)aggregation;
                    if (this.isPromotedToDouble || needsPromoting.test(longTerms.format)) {
                        if (!this.isPromotedToDouble) {
                            this.promoteToDouble(this.aggregations);
                            this.isPromotedToDouble = true;
                        }
                        this.aggregations.add(LongTerms.convertLongTermsToDouble(longTerms, LongTerms.this.format));
                    } else {
                        this.aggregations.add(aggregation);
                    }
                }
            }

            private void promoteToDouble(List<InternalAggregation> aggregations) {
                aggregations.replaceAll(aggregation -> LongTerms.convertLongTermsToDouble((LongTerms)aggregation, LongTerms.this.format));
            }

            @Override
            public InternalAggregation get() {
                try (AggregatorReducer processor = ((AbstractInternalTerms)this.aggregations.get(0)).termsAggregationReducer(reduceContext, size);){
                    this.aggregations.forEach(processor::accept);
                    this.aggregations = null;
                    InternalAggregation internalAggregation = processor.get();
                    return internalAggregation;
                }
            }
        };
    }

    @Override
    protected Bucket createBucket(long docCount, InternalAggregations aggs, long docCountError, Bucket prototype) {
        return new Bucket(prototype.term, docCount, aggs, this.showTermDocCountError, docCountError, this.format);
    }

    public static DoubleTerms convertLongTermsToDouble(LongTerms longTerms, DocValueFormat decimalFormat) {
        List buckets = longTerms.getBuckets();
        ArrayList<DoubleTerms.Bucket> newBuckets = new ArrayList<DoubleTerms.Bucket>();
        for (Terms.Bucket bucket : buckets) {
            newBuckets.add(new DoubleTerms.Bucket(bucket.getKeyAsNumber().doubleValue(), bucket.getDocCount(), bucket.getAggregations(), longTerms.showTermDocCountError, longTerms.showTermDocCountError ? bucket.getDocCountError() : 0L, decimalFormat));
        }
        return new DoubleTerms(longTerms.getName(), longTerms.reduceOrder, longTerms.order, longTerms.requiredSize, longTerms.minDocCount, (Map<String, Object>)longTerms.metadata, longTerms.format, longTerms.shardSize, longTerms.showTermDocCountError, longTerms.otherDocCount, (List<DoubleTerms.Bucket>)newBuckets, longTerms.docCountError);
    }

    public static class Bucket
    extends InternalTerms.Bucket<Bucket> {
        long term;

        public Bucket(long term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat format) {
            super(docCount, aggregations, showDocCountError, docCountError, format);
            this.term = term;
        }

        public Bucket(StreamInput in, DocValueFormat format, boolean showDocCountError) throws IOException {
            super(in, format, showDocCountError);
            this.term = in.readLong();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeLong(this.term);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.term).toString();
        }

        @Override
        public Object getKey() {
            if (this.format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                return this.format.format(this.term);
            }
            return this.term;
        }

        @Override
        public Number getKeyAsNumber() {
            if (this.format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                return (Number)this.format.format(this.term);
            }
            return this.term;
        }

        @Override
        public int compareKey(Bucket other) {
            return Long.compare(this.term, other.term);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            if (this.format == DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.format.format(this.term));
            } else {
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.term);
            }
            if (this.format != DocValueFormat.RAW && this.format != DocValueFormat.UNSIGNED_LONG_SHIFTED) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.format.format(this.term).toString());
            }
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.term, ((Bucket)obj).term);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.term);
        }
    }
}

