/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLog;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.AbstractLinearCounting;

public final class HyperLogLogPlusPlus
extends AbstractHyperLogLogPlusPlus {
    private static final float MAX_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_PRECISION = 14;
    private final BitArray algorithm;
    private final HyperLogLog hll;
    private final LinearCounting lc;

    public static int precisionFromThreshold(long count) {
        long hashTableEntries = (long)Math.ceil((float)count / 0.75f);
        int precision = PackedInts.bitsRequired((long)(hashTableEntries * 4L));
        precision = Math.max(precision, 4);
        precision = Math.min(precision, 18);
        return precision;
    }

    public static long memoryUsage(int precision) {
        return 1L << precision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HyperLogLogPlusPlus(int precision, BigArrays bigArrays, long initialBucketCount) {
        BitArray algorithm;
        LinearCounting lc;
        HyperLogLog hll;
        block3: {
            super(precision);
            hll = null;
            lc = null;
            algorithm = null;
            boolean success = false;
            try {
                hll = new HyperLogLog(bigArrays, initialBucketCount, precision);
                lc = new LinearCounting(bigArrays, initialBucketCount, precision, hll);
                algorithm = new BitArray(1L, bigArrays);
                success = true;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close((Releasable[])new Releasable[]{hll, lc, algorithm});
                }
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{hll, lc, algorithm});
        }
        this.hll = hll;
        this.lc = lc;
        this.algorithm = algorithm;
    }

    public long maxOrd() {
        return this.hll.maxOrd();
    }

    @Override
    public long cardinality(long bucketOrd) {
        if (!this.getAlgorithm(bucketOrd)) {
            return this.lc.cardinality(bucketOrd);
        }
        return this.hll.cardinality(bucketOrd);
    }

    @Override
    protected boolean getAlgorithm(long bucketOrd) {
        return this.algorithm.get(bucketOrd);
    }

    @Override
    protected AbstractLinearCounting.HashesIterator getLinearCounting(long bucketOrd) {
        return this.lc.values(bucketOrd);
    }

    @Override
    protected AbstractHyperLogLog.RunLenIterator getHyperLogLog(long bucketOrd) {
        return this.hll.getRunLens(bucketOrd);
    }

    @Override
    public void collect(long bucket, long hash) {
        this.hll.ensureCapacity(bucket + 1L);
        if (!this.algorithm.get(bucket)) {
            int newSize = this.lc.collect(bucket, hash);
            if (newSize > this.lc.threshold) {
                this.upgradeToHll(bucket);
            }
        } else {
            this.hll.collect(bucket, hash);
        }
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.algorithm, this.hll, this.lc});
    }

    protected void addRunLen(long bucketOrd, int register, int runLen) {
        if (!this.algorithm.get(bucketOrd)) {
            this.upgradeToHll(bucketOrd);
        }
        this.hll.addRunLen(0L, register, runLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeToHll(long bucketOrd) {
        this.hll.ensureCapacity(bucketOrd + 1L);
        LinearCountingIterator hashes = new LinearCountingIterator(this.lc, this.lc.readSpare, bucketOrd);
        IntArray values = this.lc.bigArrays.newIntArray(hashes.size());
        try {
            int i = 0;
            while (hashes.next()) {
                values.set(i++, hashes.value());
            }
            assert (i == hashes.size());
            this.hll.reset(bucketOrd);
            for (long j = 0L; j < values.size(); ++j) {
                int encoded = values.get(j);
                this.hll.collectEncoded(bucketOrd, encoded);
            }
            this.algorithm.set(bucketOrd);
        }
        finally {
            Releasables.close((Releasable)values);
        }
    }

    public void merge(long thisBucket, AbstractHyperLogLogPlusPlus other, long otherBucket) {
        if (this.precision() != other.precision()) {
            throw new IllegalArgumentException();
        }
        this.hll.ensureCapacity(thisBucket + 1L);
        if (!other.getAlgorithm(otherBucket)) {
            this.merge(thisBucket, other.getLinearCounting(otherBucket));
        } else {
            this.merge(thisBucket, other.getHyperLogLog(otherBucket));
        }
    }

    private void merge(long thisBucket, AbstractLinearCounting.HashesIterator values) {
        while (values.next()) {
            int encoded = values.value();
            if (!this.algorithm.get(thisBucket)) {
                int newSize = this.lc.addEncoded(thisBucket, encoded);
                if (newSize <= this.lc.threshold) continue;
                this.upgradeToHll(thisBucket);
                continue;
            }
            this.hll.collectEncoded(thisBucket, encoded);
        }
    }

    private void merge(long thisBucket, AbstractHyperLogLog.RunLenIterator runLens) {
        if (!this.algorithm.get(thisBucket)) {
            this.upgradeToHll(thisBucket);
        }
        for (int i = 0; i < this.hll.m; ++i) {
            runLens.next();
            this.hll.addRunLen(thisBucket, i, runLens.value());
        }
    }

    private static class HyperLogLog
    extends AbstractHyperLogLog
    implements Releasable {
        private final BigArrays bigArrays;
        private ByteArray runLens;

        HyperLogLog(BigArrays bigArrays, long initialBucketCount, int precision) {
            super(precision);
            this.runLens = bigArrays.newByteArray(initialBucketCount << precision);
            this.bigArrays = bigArrays;
        }

        public long maxOrd() {
            return this.runLens.size() >>> this.precision();
        }

        @Override
        protected void addRunLen(long bucketOrd, int register, int encoded) {
            long bucketIndex = (bucketOrd << this.p) + (long)register;
            this.runLens.set(bucketIndex, (byte)Math.max(encoded, this.runLens.get(bucketIndex)));
        }

        @Override
        protected AbstractHyperLogLog.RunLenIterator getRunLens(long bucketOrd) {
            return new HyperLogLogIterator(this, bucketOrd);
        }

        protected void reset(long bucketOrd) {
            this.runLens.fill(bucketOrd << this.p, (bucketOrd << this.p) + (long)this.m, (byte)0);
        }

        protected void ensureCapacity(long numBuckets) {
            this.runLens = this.bigArrays.grow(this.runLens, numBuckets << this.p);
        }

        public void close() {
            Releasables.close((Releasable)this.runLens);
        }
    }

    private static class LinearCounting
    extends AbstractLinearCounting
    implements Releasable {
        protected final int threshold;
        private final int mask;
        private final BytesRef readSpare;
        private final ByteBuffer writeSpare;
        private final BigArrays bigArrays;
        private final HyperLogLog hll;
        private final int capacity;
        private IntArray sizes;

        LinearCounting(BigArrays bigArrays, long initialBucketCount, int p, HyperLogLog hll) {
            super(p);
            this.bigArrays = bigArrays;
            this.hll = hll;
            this.capacity = (1 << p) / 4;
            this.threshold = (int)((float)this.capacity * 0.75f);
            this.mask = this.capacity - 1;
            this.sizes = bigArrays.newIntArray(initialBucketCount);
            this.readSpare = new BytesRef();
            this.writeSpare = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        protected int addEncoded(long bucketOrd, int encoded) {
            this.sizes = this.bigArrays.grow(this.sizes, bucketOrd + 1L);
            assert (encoded != 0);
            int i = encoded & this.mask;
            while (true) {
                this.hll.runLens.get(this.index(bucketOrd, i), 4, this.readSpare);
                int v = ByteUtils.readIntLE(this.readSpare.bytes, this.readSpare.offset);
                if (v == 0) {
                    this.set(bucketOrd, i, encoded);
                    return this.sizes.increment(bucketOrd, 1);
                }
                if (v == encoded) {
                    return -1;
                }
                i = i + 1 & this.mask;
            }
        }

        @Override
        protected int size(long bucketOrd) {
            if (bucketOrd >= this.sizes.size()) {
                return 0;
            }
            int size = this.sizes.get(bucketOrd);
            assert (size == this.recomputedSize(bucketOrd));
            return size;
        }

        private AbstractLinearCounting.HashesIterator values(long bucketOrd) {
            return new LinearCountingIterator(this, new BytesRef(), bucketOrd);
        }

        private long index(long bucketOrd, int index) {
            return (bucketOrd << this.p) + (long)(index << 2);
        }

        private void set(long bucketOrd, int index, int value) {
            this.writeSpare.putInt(0, value);
            this.hll.runLens.set(this.index(bucketOrd, index), this.writeSpare.array(), 0, 4);
        }

        private int recomputedSize(long bucketOrd) {
            if (bucketOrd >= this.hll.maxOrd()) {
                return 0;
            }
            int size = 0;
            BytesRef spare = new BytesRef();
            for (int i = 0; i <= this.mask; ++i) {
                this.hll.runLens.get(this.index(bucketOrd, i), 4, spare);
                int v = ByteUtils.readIntLE(spare.bytes, spare.offset);
                if (v == 0) continue;
                ++size;
            }
            return size;
        }

        public void close() {
            Releasables.close((Releasable)this.sizes);
        }
    }

    private static class LinearCountingIterator
    implements AbstractLinearCounting.HashesIterator {
        private final LinearCounting lc;
        private final BytesRef spare;
        private final long bucketOrd;
        private final int size;
        private int pos;
        private int value;

        LinearCountingIterator(LinearCounting lc, BytesRef spare, long bucketOrd) {
            this.lc = lc;
            this.spare = spare;
            this.bucketOrd = bucketOrd;
            this.size = lc.size(bucketOrd);
            this.pos = this.size == 0 ? lc.capacity : 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean next() {
            if (this.pos < this.lc.capacity) {
                while (this.pos < this.lc.capacity) {
                    this.lc.hll.runLens.get(this.lc.index(this.bucketOrd, this.pos), 4, this.spare);
                    int k = ByteUtils.readIntLE(this.spare.bytes, this.spare.offset);
                    if (k != 0) {
                        ++this.pos;
                        this.value = k;
                        return true;
                    }
                    ++this.pos;
                }
            }
            return false;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private static class HyperLogLogIterator
    implements AbstractHyperLogLog.RunLenIterator {
        private final HyperLogLog hll;
        int pos;
        final long start;
        private byte value;

        HyperLogLogIterator(HyperLogLog hll, long bucket) {
            this.hll = hll;
            this.start = bucket << hll.p;
        }

        @Override
        public boolean next() {
            if (this.pos < this.hll.m) {
                this.value = this.hll.runLens.get(this.start + (long)this.pos);
                ++this.pos;
                return true;
            }
            return false;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }
}

