/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Executor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.transport.ResponseStatsConsumer;
import org.elasticsearch.transport.TaskTransportChannel;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.TransportActionStats;
import org.elasticsearch.transport.TransportActionStatsTracker;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;

public class RequestHandlerRegistry<Request extends TransportRequest>
implements ResponseStatsConsumer {
    private final String action;
    private final TransportRequestHandler<Request> handler;
    private final boolean forceExecution;
    private final boolean canTripCircuitBreaker;
    private final Executor executor;
    private final TaskManager taskManager;
    private final Tracer tracer;
    private final Writeable.Reader<Request> requestReader;
    private TransportActionStatsTracker statsTracker;
    private static final VarHandle STATS_TRACKER_HANDLE;

    public RequestHandlerRegistry(String action, Writeable.Reader<Request> requestReader, TaskManager taskManager, TransportRequestHandler<Request> handler, Executor executor, boolean forceExecution, boolean canTripCircuitBreaker, Tracer tracer) {
        this.action = action;
        this.requestReader = requestReader;
        this.handler = handler;
        this.forceExecution = forceExecution;
        this.canTripCircuitBreaker = canTripCircuitBreaker;
        this.executor = executor;
        this.taskManager = taskManager;
        this.tracer = tracer;
    }

    public String getAction() {
        return this.action;
    }

    public Request newRequest(StreamInput in) throws IOException {
        return (Request)((TransportRequest)this.requestReader.read(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessageReceived(Request request, TransportChannel channel) throws Exception {
        Task task = this.taskManager.register("transport", this.action, (TaskAwareRequest)request);
        Releasable unregisterTask = () -> this.taskManager.unregister(task);
        try {
            if (channel instanceof TcpTransportChannel) {
                TcpTransportChannel tcpTransportChannel = (TcpTransportChannel)channel;
                if (task instanceof CancellableTask) {
                    CancellableTask cancellableTask = (CancellableTask)task;
                    TcpChannel tcpChannel = tcpTransportChannel.getChannel();
                    Releasable stopTracking = this.taskManager.startTrackingCancellableChannelTask(tcpChannel, cancellableTask);
                    unregisterTask = Releasables.wrap((Releasable[])new Releasable[]{unregisterTask, stopTracking});
                }
            }
            TaskTransportChannel taskTransportChannel = new TaskTransportChannel(task.getId(), channel, Releasables.assertOnce((Releasable)unregisterTask));
            this.handler.messageReceived(request, taskTransportChannel, task);
            unregisterTask = null;
        }
        finally {
            Releasables.close((Releasable)unregisterTask);
        }
    }

    public boolean isForceExecution() {
        return this.forceExecution;
    }

    public boolean canTripCircuitBreaker() {
        return this.canTripCircuitBreaker;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public TransportRequestHandler<Request> getHandler() {
        return this.handler;
    }

    public String toString() {
        return this.handler.toString();
    }

    public static <R extends TransportRequest> RequestHandlerRegistry<R> replaceHandler(RequestHandlerRegistry<R> registry, TransportRequestHandler<R> handler) {
        return new RequestHandlerRegistry(registry.action, registry.requestReader, registry.taskManager, handler, registry.executor, registry.forceExecution, registry.canTripCircuitBreaker, registry.tracer);
    }

    public void addRequestStats(int messageSize) {
        this.statsTracker().addRequestStats(messageSize);
    }

    @Override
    public void addResponseStats(int messageSize) {
        this.statsTracker().addResponseStats(messageSize);
    }

    public TransportActionStats getStats() {
        TransportActionStatsTracker statsTracker = this.existingStatsTracker();
        if (statsTracker == null) {
            return TransportActionStats.EMPTY;
        }
        return statsTracker.getStats();
    }

    private TransportActionStatsTracker statsTracker() {
        TransportActionStatsTracker newTracker;
        TransportActionStatsTracker tracker = this.existingStatsTracker();
        if (tracker == null && (tracker = STATS_TRACKER_HANDLE.compareAndExchange(this, null, newTracker = new TransportActionStatsTracker())) == null) {
            tracker = newTracker;
        }
        return tracker;
    }

    private TransportActionStatsTracker existingStatsTracker() {
        return STATS_TRACKER_HANDLE.getAcquire(this);
    }

    static {
        try {
            STATS_TRACKER_HANDLE = MethodHandles.lookup().findVarHandle(RequestHandlerRegistry.class, "statsTracker", TransportActionStatsTracker.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

