/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.lucene.LuceneQueryEvaluator;
import org.elasticsearch.compute.lucene.LuceneQueryExpressionEvaluator;
import org.elasticsearch.compute.lucene.LuceneQueryScoreEvaluator;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.ScoreOperator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Kql;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Match;
import org.elasticsearch.xpack.esql.expression.function.fulltext.QueryString;
import org.elasticsearch.xpack.esql.expression.function.fulltext.Term;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.TranslationAwareExpressionQuery;
import org.elasticsearch.xpack.esql.score.ExpressionScoreMapper;

public abstract class FullTextFunction
extends org.elasticsearch.xpack.esql.core.expression.function.Function
implements TranslationAware,
PostAnalysisPlanVerificationAware,
EvaluatorMapper,
ExpressionScoreMapper {
    private final Expression query;
    private final QueryBuilder queryBuilder;

    protected FullTextFunction(Source source, Expression query, List<Expression> children, QueryBuilder queryBuilder) {
        super(source, children);
        this.query = query;
        this.queryBuilder = queryBuilder;
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    protected final Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return this.resolveParams();
    }

    protected Expression.TypeResolution resolveParams() {
        return this.resolveQuery(TypeResolutions.ParamOrdinal.DEFAULT);
    }

    protected Expression.TypeResolution resolveQuery(TypeResolutions.ParamOrdinal queryOrdinal) {
        return TypeResolutions.isString((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)queryOrdinal).and(TypeResolutions.isNotNullAndFoldable((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)queryOrdinal));
    }

    public Expression query() {
        return this.query;
    }

    public Object queryAsObject() {
        Object queryAsObject = this.query().fold(FoldContext.small());
        if (queryAsObject instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)queryAsObject;
            return bytesRef.utf8ToString();
        }
        return queryAsObject;
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    public String functionType() {
        return "function";
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.queryBuilder);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.queryBuilder, ((FullTextFunction)obj).queryBuilder);
    }

    @Override
    public boolean translatable(LucenePushdownPredicates pushdownPredicates) {
        return true;
    }

    @Override
    public Query asQuery(TranslatorHandler handler) {
        return this.queryBuilder != null ? new TranslationAwareExpressionQuery(this.source(), this.queryBuilder) : this.translate(handler);
    }

    public QueryBuilder queryBuilder() {
        return this.queryBuilder;
    }

    protected abstract Query translate(TranslatorHandler var1);

    public abstract Expression replaceQueryBuilder(QueryBuilder var1);

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return FullTextFunction::checkFullTextQueryFunctions;
    }

    private static void checkFullTextQueryFunctions(LogicalPlan plan, Failures failures) {
        if (plan instanceof Filter) {
            Filter f = (Filter)plan;
            Expression condition = f.condition();
            List.of(QueryString.class, Kql.class).forEach(functionClass -> FullTextFunction.checkCommandsBeforeExpression(plan, condition, functionClass, lp -> lp instanceof Filter || lp instanceof OrderBy || lp instanceof EsRelation, fullTextFunction -> "[" + fullTextFunction.functionName() + "] " + fullTextFunction.functionType(), failures));
            FullTextFunction.checkCommandsBeforeExpression(plan, condition, Match.class, lp -> !(lp instanceof Limit) && !(lp instanceof Aggregate), m -> "[" + m.functionName() + "] " + m.functionType(), failures);
            FullTextFunction.checkCommandsBeforeExpression(plan, condition, Term.class, lp -> !(lp instanceof Limit) && !(lp instanceof Aggregate), m -> "[" + m.functionName() + "] " + m.functionType(), failures);
            FullTextFunction.checkFullTextFunctionsParents(condition, failures);
        } else {
            plan.forEachExpression(FullTextFunction.class, ftf -> failures.add(Failure.fail(ftf, "[{}] {} is only supported in WHERE commands", new Object[]{ftf.functionName(), ftf.functionType()})));
        }
    }

    private static <E extends Expression> void checkCommandsBeforeExpression(LogicalPlan plan, Expression condition, Class<E> typeToken, Predicate<LogicalPlan> commandCheck, Function<E, String> typeErrorMsgProvider, Failures failures) {
        condition.forEachDown(typeToken, exp -> plan.forEachDown(LogicalPlan.class, lp -> {
            if (!commandCheck.test((LogicalPlan)((Object)lp))) {
                failures.add(Failure.fail(plan, "{} cannot be used after {}", typeErrorMsgProvider.apply(exp), lp.sourceText().split(" ")[0].toUpperCase(Locale.ROOT)));
            }
        }));
    }

    private static void checkFullTextFunctionsParents(Expression condition, Failures failures) {
        FullTextFunction.forEachFullTextFunctionParent(condition, (ftf, parent) -> {
            if (!(parent instanceof FullTextFunction || parent instanceof BinaryLogic || parent instanceof Not)) {
                failures.add(Failure.fail(condition, "Invalid condition [{}]. [{}] {} can't be used with {}", new Object[]{condition.sourceText(), ftf.functionName(), ftf.functionType(), ((org.elasticsearch.xpack.esql.core.expression.function.Function)parent).functionName()}));
            }
        });
    }

    private static FullTextFunction forEachFullTextFunctionParent(Expression condition, BiConsumer<FullTextFunction, Expression> action) {
        if (condition instanceof FullTextFunction) {
            FullTextFunction ftf = (FullTextFunction)condition;
            return ftf;
        }
        for (Expression child : condition.children()) {
            FullTextFunction foundMatchingChild = FullTextFunction.forEachFullTextFunctionParent(child, action);
            if (foundMatchingChild == null) continue;
            action.accept(foundMatchingChild, condition);
            return foundMatchingChild;
        }
        return null;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        List<EsPhysicalOperationProviders.ShardContext> shardContexts = toEvaluator.shardContexts();
        LuceneQueryEvaluator.ShardConfig[] shardConfigs = new LuceneQueryEvaluator.ShardConfig[shardContexts.size()];
        int i = 0;
        for (EsPhysicalOperationProviders.ShardContext shardContext : shardContexts) {
            shardConfigs[i++] = new LuceneQueryEvaluator.ShardConfig(shardContext.toQuery(this.queryBuilder()), shardContext.searcher());
        }
        return new LuceneQueryExpressionEvaluator.Factory(shardConfigs);
    }

    @Override
    public ScoreOperator.ExpressionScorer.Factory toScorer(ExpressionScoreMapper.ToScorer toScorer) {
        List<EsPhysicalOperationProviders.ShardContext> shardContexts = toScorer.shardContexts();
        LuceneQueryEvaluator.ShardConfig[] shardConfigs = new LuceneQueryEvaluator.ShardConfig[shardContexts.size()];
        int i = 0;
        for (EsPhysicalOperationProviders.ShardContext shardContext : shardContexts) {
            shardConfigs[i++] = new LuceneQueryEvaluator.ShardConfig(shardContext.toQuery(this.queryBuilder()), shardContext.searcher());
        }
        return new LuceneQueryScoreEvaluator.Factory(shardConfigs);
    }
}

