/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.expression.EntryExpression;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.MultiTypeEsField;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.MapParam;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.querydsl.query.MatchQuery;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Match
extends FullTextFunction
implements OptionalArgument,
PostOptimizationVerificationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Match", Match::readFrom);
    public static final Set<DataType> FIELD_DATA_TYPES = Set.of(DataType.KEYWORD, DataType.TEXT, DataType.SEMANTIC_TEXT, DataType.BOOLEAN, DataType.DATETIME, DataType.DATE_NANOS, DataType.DOUBLE, DataType.INTEGER, DataType.IP, DataType.LONG, DataType.UNSIGNED_LONG, DataType.VERSION);
    public static final Set<DataType> QUERY_DATA_TYPES = Set.of(DataType.KEYWORD, DataType.BOOLEAN, DataType.DATETIME, DataType.DATE_NANOS, DataType.DOUBLE, DataType.INTEGER, DataType.IP, DataType.LONG, DataType.UNSIGNED_LONG, DataType.VERSION);
    protected final Expression field;
    private final transient Expression options;
    public static final Map<String, DataType> ALLOWED_OPTIONS = Map.ofEntries(Map.entry(MatchQueryBuilder.ANALYZER_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MatchQueryBuilder.GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), DataType.BOOLEAN), Map.entry(Fuzziness.FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(AbstractQueryBuilder.BOOST_FIELD.getPreferredName(), DataType.FLOAT), Map.entry(MatchQueryBuilder.FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(MatchQueryBuilder.FUZZY_REWRITE_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MatchQueryBuilder.LENIENT_FIELD.getPreferredName(), DataType.BOOLEAN), Map.entry(MatchQueryBuilder.MAX_EXPANSIONS_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(MatchQueryBuilder.MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MatchQueryBuilder.OPERATOR_FIELD.getPreferredName(), DataType.KEYWORD), Map.entry(MatchQueryBuilder.PREFIX_LENGTH_FIELD.getPreferredName(), DataType.INTEGER), Map.entry(MatchQueryBuilder.ZERO_TERMS_QUERY_FIELD.getPreferredName(), DataType.KEYWORD));

    @FunctionInfo(returnType={"boolean"}, preview=true, description="Use `MATCH` to perform a <<query-dsl-match-query,match query>> on the specified field.\nUsing `MATCH` is equivalent to using the `match` query in the Elasticsearch Query DSL.\n\nMatch can be used on fields from the text family like <<text, text>> and <<semantic-text, semantic_text>>,\nas well as other field types like keyword, boolean, dates, and numeric types.\n\nMatch can use <<esql-function-named-params,function named parameters>> to specify additional options for the match query.\nAll <<match-field-params,match query parameters>> are supported.\n\nFor a simplified syntax, you can use the <<esql-match-operator,match operator>> `:` operator instead of `MATCH`.\n\n`MATCH` returns true if the provided query matches the row.", examples={@Example(file="match-function", tag="match-with-field"), @Example(file="match-function", tag="match-with-named-function-params")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.COMING, description="Support for optional named parameters is only available in serverless, or in a future {{es}} release")})
    public Match(Source source, @Param(name="field", type={"keyword", "text", "boolean", "date", "date_nanos", "double", "integer", "ip", "long", "unsigned_long", "version"}, description="Field that the query will target.") Expression field, @Param(name="query", type={"keyword", "boolean", "date", "date_nanos", "double", "integer", "ip", "long", "unsigned_long", "version"}, description="Value to find in the provided field.") Expression matchQuery, @MapParam(name="options", params={@MapParam.MapParamEntry(name="analyzer", type={"keyword"}, valueHint={"standard"}, description="Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index\u2019s default analyzer is used."), @MapParam.MapParamEntry(name="auto_generate_synonyms_phrase_query", type={"boolean"}, valueHint={"true", "false"}, description="If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true."), @MapParam.MapParamEntry(name="fuzziness", type={"keyword"}, valueHint={"AUTO", "1", "2"}, description="Maximum edit distance allowed for matching."), @MapParam.MapParamEntry(name="boost", type={"float"}, valueHint={"2.5"}, description="Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0."), @MapParam.MapParamEntry(name="fuzzy_transpositions", type={"boolean"}, valueHint={"true", "false"}, description="If true, edits for fuzzy matching include transpositions of two adjacent characters (ab \u2192 ba). Defaults to true."), @MapParam.MapParamEntry(name="fuzzy_rewrite", type={"keyword"}, valueHint={"constant_score_blended", "constant_score", "constant_score_boolean", "top_terms_blended_freqs_N", "top_terms_boost_N", "top_terms_N"}, description="Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default."), @MapParam.MapParamEntry(name="lenient", type={"boolean"}, valueHint={"true", "false"}, description="If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false."), @MapParam.MapParamEntry(name="max_expansions", type={"integer"}, valueHint={"50"}, description="Maximum number of terms to which the query will expand. Defaults to 50."), @MapParam.MapParamEntry(name="minimum_should_match", type={"integer"}, valueHint={"2"}, description="Minimum number of clauses that must match for a document to be returned."), @MapParam.MapParamEntry(name="operator", type={"keyword"}, valueHint={"AND", "OR"}, description="Boolean logic used to interpret text in the query value. Defaults to OR."), @MapParam.MapParamEntry(name="prefix_length", type={"integer"}, valueHint={"1"}, description="Number of beginning characters left unchanged for fuzzy matching. Defaults to 0."), @MapParam.MapParamEntry(name="zero_terms_query", type={"keyword"}, valueHint={"none", "all"}, description="Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.")}, description="(Optional) Match additional options as <<esql-function-named-params,function named parameters>>. See <<query-dsl-match-query,match query>> for more information.", optional=true) Expression options) {
        this(source, field, matchQuery, options, null);
    }

    public Match(Source source, Expression field, Expression matchQuery, Expression options, QueryBuilder queryBuilder) {
        super(source, matchQuery, options == null ? List.of(field, matchQuery) : List.of(field, matchQuery, options), queryBuilder);
        this.field = field;
        this.options = options;
    }

    public String getWriteableName() {
        return Match.ENTRY.name;
    }

    private static Match readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Expression field = (Expression)in.readNamedWriteable(Expression.class);
        Expression query = (Expression)in.readNamedWriteable(Expression.class);
        QueryBuilder queryBuilder = null;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_QUERY_BUILDER_IN_SEARCH_FUNCTIONS)) {
            queryBuilder = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        }
        return new Match(source, field, query, null, queryBuilder);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        out.writeNamedWriteable((NamedWriteable)this.query());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_QUERY_BUILDER_IN_SEARCH_FUNCTIONS)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.queryBuilder());
        }
    }

    @Override
    protected Expression.TypeResolution resolveParams() {
        return this.resolveField().and(this.resolveQuery()).and(this.resolveOptions()).and(this.checkParamCompatibility());
    }

    private Expression.TypeResolution resolveField() {
        return TypeResolutions.isNotNull((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isType((Expression)this.field, FIELD_DATA_TYPES::contains, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"keyword, text, boolean, date, date_nanos, double, integer, ip, long, unsigned_long, version"}));
    }

    private Expression.TypeResolution resolveQuery() {
        return TypeResolutions.isType((Expression)this.query(), QUERY_DATA_TYPES::contains, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"keyword, boolean, date, date_nanos, double, integer, ip, long, unsigned_long, version"}).and(TypeResolutions.isNotNullAndFoldable((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    private Expression.TypeResolution checkParamCompatibility() {
        DataType queryType;
        DataType fieldType = this.field().dataType();
        if (fieldType == (queryType = this.query().dataType()) || queryType == DataType.KEYWORD) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (fieldType.isNumeric() && queryType.isNumeric() && !(queryType == DataType.UNSIGNED_LONG && fieldType != DataType.UNSIGNED_LONG)) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution(EsqlBinaryComparison.formatIncompatibleTypesMessage(fieldType, queryType, this.sourceText()));
    }

    private Expression.TypeResolution resolveOptions() {
        if (this.options() != null) {
            Expression.TypeResolution resolution = TypeResolutions.isNotNull((Expression)this.options(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = TypeResolutions.isMapExpression((Expression)this.options(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
            if (resolution.unresolved()) {
                return resolution;
            }
            try {
                this.matchQueryOptions();
            }
            catch (InvalidArgumentException e) {
                return new Expression.TypeResolution(e.getMessage());
            }
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    private Map<String, Object> matchQueryOptions() throws InvalidArgumentException {
        if (this.options() == null) {
            return Map.of(MatchQueryBuilder.LENIENT_FIELD.getPreferredName(), true);
        }
        HashMap<String, Object> matchOptions = new HashMap<String, Object>();
        matchOptions.put(MatchQueryBuilder.LENIENT_FIELD.getPreferredName(), true);
        for (EntryExpression entry : ((MapExpression)this.options()).entryExpressions()) {
            String string;
            String optionName;
            Expression optionExpr = entry.key();
            Expression valueExpr = entry.value();
            Expression.TypeResolution resolution = TypeResolutions.isFoldable((Expression)optionExpr, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isFoldable((Expression)valueExpr, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
            if (resolution.unresolved()) {
                throw new InvalidArgumentException(resolution.message(), new Object[0]);
            }
            Object optionExprLiteral = ((Literal)optionExpr).value();
            Object valueExprLiteral = ((Literal)valueExpr).value();
            if (optionExprLiteral instanceof BytesRef) {
                BytesRef br = (BytesRef)optionExprLiteral;
                v0 = br.utf8ToString();
            } else {
                v0 = optionName = optionExprLiteral.toString();
            }
            if (valueExprLiteral instanceof BytesRef) {
                BytesRef br = (BytesRef)valueExprLiteral;
                string = br.utf8ToString();
            } else {
                string = valueExprLiteral.toString();
            }
            String optionValue = string;
            DataType dataType = ALLOWED_OPTIONS.get(optionName);
            if (dataType == null) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"Invalid option [{}] in [{}], expected one of {}", (Object[])new Object[]{optionName, this.sourceText(), ALLOWED_OPTIONS.keySet()}), new Object[0]);
            }
            try {
                matchOptions.put(optionName, DataTypeConverter.convert((Object)optionValue, (DataType)dataType));
            }
            catch (InvalidArgumentException e) {
                throw new InvalidArgumentException(LoggerMessageFormat.format(null, (String)"Invalid option [{}] in [{}], {}", (Object[])new Object[]{optionName, this.sourceText(), e.getMessage()}), new Object[0]);
            }
        }
        return matchOptions;
    }

    public Expression field() {
        return this.field;
    }

    public Expression options() {
        return this.options;
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Match::new, (Object)this.field(), (Object)this.query(), (Object)this.options(), (Object)this.queryBuilder());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Match(this.source(), newChildren.get(0), newChildren.get(1), newChildren.size() > 2 ? newChildren.get(2) : null, this.queryBuilder());
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new Match(this.source(), this.field, this.query(), this.options(), queryBuilder);
    }

    @Override
    public void postOptimizationVerification(Failures failures) {
        Expression fieldExpression = this.field();
        if (fieldExpression instanceof AbstractConvertFunction) {
            AbstractConvertFunction convertFunction = (AbstractConvertFunction)fieldExpression;
            fieldExpression = convertFunction.field();
        }
        if (!(fieldExpression instanceof FieldAttribute)) {
            failures.add(Failure.fail(this.field, "[{}] {} cannot operate on [{}], which is not a field from an index mapping", new Object[]{this.functionName(), this.functionType(), this.field.sourceText()}));
        }
    }

    @Override
    public Object queryAsObject() {
        Object queryAsObject = this.query().fold(FoldContext.small());
        if (queryAsObject instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)queryAsObject;
            return switch (this.query().dataType()) {
                case DataType.IP -> EsqlDataTypeConverter.ipToString(bytesRef);
                case DataType.VERSION -> EsqlDataTypeConverter.versionToString(bytesRef);
                default -> bytesRef.utf8ToString();
            };
        }
        if (this.query().dataType() == DataType.UNSIGNED_LONG) {
            return NumericUtils.unsignedLongAsBigInteger((long)((Long)queryAsObject));
        }
        if (this.query().dataType() == DataType.DATETIME && queryAsObject instanceof Long) {
            return EsqlDataTypeConverter.dateTimeToString((Long)queryAsObject);
        }
        if (this.query().dataType() == DataType.DATE_NANOS && queryAsObject instanceof Long) {
            return EsqlDataTypeConverter.nanoTimeToString((Long)queryAsObject);
        }
        return queryAsObject;
    }

    @Override
    protected Query translate(TranslatorHandler handler) {
        Expression fieldExpression = this.field;
        if (fieldExpression instanceof AbstractConvertFunction) {
            AbstractConvertFunction convertFunction = (AbstractConvertFunction)fieldExpression;
            fieldExpression = convertFunction.field();
        }
        if (fieldExpression instanceof FieldAttribute) {
            FieldAttribute fieldAttribute = (FieldAttribute)fieldExpression;
            String fieldName = fieldAttribute.name();
            EsField esField = fieldAttribute.field();
            if (esField instanceof MultiTypeEsField) {
                MultiTypeEsField multiTypeEsField = (MultiTypeEsField)esField;
                fieldName = multiTypeEsField.getName();
            }
            return new MatchQuery(this.source(), fieldName, this.queryAsObject(), this.matchQueryOptions());
        }
        throw new IllegalArgumentException("Match must have a field attribute as the first argument");
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Match match = (Match)o;
        return Objects.equals(this.field(), match.field()) && Objects.equals(this.query(), match.query()) && Objects.equals(this.queryBuilder(), match.queryBuilder());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.query(), this.queryBuilder());
    }
}

