/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLong;

public final class ToUnsignedLongFromIntEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private final EvalOperator.ExpressionEvaluator i;

    public ToUnsignedLongFromIntEvaluator(Source source, EvalOperator.ExpressionEvaluator i, DriverContext driverContext) {
        super(driverContext, source);
        this.i = i;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.i;
    }

    @Override
    public Block evalVector(Vector v) {
        IntVector vector = (IntVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            try {
                return this.driverContext.blockFactory().newConstantLongBlockWith(this.evalValue(vector, 0), positionCount);
            }
            catch (InvalidArgumentException e) {
                this.registerException((Exception)((Object)e));
                return this.driverContext.blockFactory().newConstantNullBlock(positionCount);
            }
        }
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    builder.appendLong(this.evalValue(vector, p));
                    continue;
                }
                catch (InvalidArgumentException e) {
                    this.registerException((Exception)((Object)e));
                    builder.appendNull();
                }
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private long evalValue(IntVector container, int index) {
        int value = container.getInt(index);
        return ToUnsignedLong.fromInt(value);
    }

    @Override
    public Block evalBlock(Block b) {
        IntBlock block = (IntBlock)b;
        int positionCount = block.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    try {
                        long value = this.evalValue(block, i);
                        if (!positionOpened && valueCount > 1) {
                            builder.beginPositionEntry();
                            positionOpened = true;
                        }
                        builder.appendLong(value);
                        valuesAppended = true;
                        continue;
                    }
                    catch (InvalidArgumentException e) {
                        this.registerException((Exception)((Object)e));
                    }
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private long evalValue(IntBlock container, int index) {
        int value = container.getInt(index);
        return ToUnsignedLong.fromInt(value);
    }

    public String toString() {
        return "ToUnsignedLongFromIntEvaluator[i=" + String.valueOf(this.i) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.i);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory i;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory i) {
            this.source = source;
            this.i = i;
        }

        public ToUnsignedLongFromIntEvaluator get(DriverContext context) {
            return new ToUnsignedLongFromIntEvaluator(this.source, this.i.get(context), context);
        }

        public String toString() {
            return "ToUnsignedLongFromIntEvaluator[i=" + String.valueOf(this.i) + "]";
        }
    }
}

