/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.optimizer.rules.PlanConsistencyChecker;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public final class LogicalVerifier {
    public static final LogicalVerifier INSTANCE = new LogicalVerifier();

    private LogicalVerifier() {
    }

    public Failures verify(LogicalPlan plan) {
        Failures failures = new Failures();
        Failures dependencyFailures = new Failures();
        plan.forEachUp(p -> {
            PlanConsistencyChecker.checkPlan(p, dependencyFailures);
            if (!failures.hasFailures()) {
                if (p instanceof PostOptimizationVerificationAware) {
                    PostOptimizationVerificationAware pova = (PostOptimizationVerificationAware)((Object)p);
                    pova.postOptimizationVerification(failures);
                }
                p.forEachExpression(ex -> {
                    if (ex instanceof PostOptimizationVerificationAware) {
                        PostOptimizationVerificationAware va = (PostOptimizationVerificationAware)ex;
                        va.postOptimizationVerification(failures);
                    }
                });
            }
        });
        if (dependencyFailures.hasFailures()) {
            throw new IllegalStateException(dependencyFailures.toString());
        }
        return failures;
    }
}

