/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo;

import java.time.LocalDate;
import org.ojalgo.machine.Hardware;
import org.ojalgo.machine.VirtualMachine;
import org.ojalgo.matrix.operation.MatrixOperation;
import org.ojalgo.netio.BasicLogger;

public abstract class OjAlgoUtils {
    public static VirtualMachine ENVIRONMENT = null;

    public static String getDate() {
        String manifestValue = OjAlgoUtils.class.getPackage().getSpecificationVersion();
        return manifestValue != null ? manifestValue : LocalDate.now().toString();
    }

    public static String getTitle() {
        String manifestValue = OjAlgoUtils.class.getPackage().getImplementationTitle();
        return manifestValue != null ? manifestValue : "ojAlgo";
    }

    public static String getVendor() {
        String manifestValue = OjAlgoUtils.class.getPackage().getImplementationVendor();
        return manifestValue != null ? manifestValue : "Optimatika";
    }

    public static String getVersion() {
        String manifestValue = OjAlgoUtils.class.getPackage().getImplementationVersion();
        return manifestValue != null ? manifestValue : "X.Y.Z";
    }

    public static void limitCoresTo(int maxCores) {
        double newCores = Math.max(1, Math.min(OjAlgoUtils.ENVIRONMENT.cores, maxCores));
        ENVIRONMENT = ENVIRONMENT.limitBy(newCores / (double)OjAlgoUtils.ENVIRONMENT.cores);
    }

    public static void limitEnvironmentBy(double fraction) {
        ENVIRONMENT = ENVIRONMENT.limitBy(fraction);
    }

    public static void limitThreadsTo(int maxThreads) {
        double newThreads = Math.max(1, Math.min(OjAlgoUtils.ENVIRONMENT.threads, maxThreads));
        ENVIRONMENT = ENVIRONMENT.limitBy(newThreads / (double)OjAlgoUtils.ENVIRONMENT.threads);
    }

    public static void limitUnitsTo(int maxUnits) {
        double newUnits = Math.max(1, Math.min(OjAlgoUtils.ENVIRONMENT.units, maxUnits));
        ENVIRONMENT = ENVIRONMENT.limitBy(newUnits / (double)OjAlgoUtils.ENVIRONMENT.units);
    }

    public static void main(String[] args) {
        BasicLogger.debug();
        BasicLogger.debug("####################################################################");
        BasicLogger.debug("#################### Welcome to oj! Algorithms #####################");
        BasicLogger.debug("####################################################################");
        BasicLogger.debug("{} version {} built by {}.", OjAlgoUtils.getTitle(), OjAlgoUtils.getVersion(), OjAlgoUtils.getVendor());
        BasicLogger.debug("####################################################################");
        BasicLogger.debug();
        BasicLogger.debug("Machine Architecture: {}", VirtualMachine.getArchitecture());
        BasicLogger.debug("Machine Threads: {}", VirtualMachine.getThreads());
        BasicLogger.debug("Machine Memory: {}", VirtualMachine.getMemory());
        BasicLogger.debug();
        BasicLogger.debug("ojAlgo Environment: {}", ENVIRONMENT);
        BasicLogger.debug();
        BasicLogger.debug("System properties: {}", System.getProperties());
        BasicLogger.debug();
    }

    public static void pushUpConcurrencyThresholds(int minValue) {
        MatrixOperation.setThresholdsMinValue(minValue);
    }

    private OjAlgoUtils() {
    }

    static {
        String architecture = VirtualMachine.getArchitecture();
        long memory = VirtualMachine.getMemory();
        int threads = VirtualMachine.getThreads();
        for (Hardware hw : Hardware.PREDEFINED) {
            if (!hw.architecture.equals(architecture) || hw.threads != threads || hw.memory < memory) continue;
            ENVIRONMENT = hw.virtualise();
        }
        if (ENVIRONMENT == null) {
            if (System.getProperty("shut.up.ojAlgo") == null) {
                BasicLogger.debug("ojAlgo includes a small set of predefined hardware profiles,");
                BasicLogger.debug("none of which were deemed suitable for the hardware you're currently using.");
                BasicLogger.debug("A default hardware profile, that is perfectly usable, has been set for you.");
                BasicLogger.debug("You may want to set org.ojalgo.OjAlgoUtils.ENVIRONMENT to something that");
                BasicLogger.debug("better matches the hardware/OS/JVM you're running on, than the default.");
                BasicLogger.debug("Additionally it would be appreciated if you contribute your hardware profile:");
                BasicLogger.debug("https://github.com/optimatika/ojAlgo/issues");
                BasicLogger.debug("Architecture={} Threads={} Memory={}", architecture, threads, memory);
            }
            ENVIRONMENT = Hardware.makeSimple(architecture, memory, threads).virtualise();
        }
    }
}

