/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;

abstract class AbstractDecomposition<N extends Comparable<N>>
implements MatrixDecomposition<N> {
    private boolean myComputed = false;
    private Boolean mySolvable = null;

    AbstractDecomposition() {
    }

    @Override
    public final long countColumns() {
        return this.getColDim();
    }

    @Override
    public final long countRows() {
        return this.getRowDim();
    }

    @Override
    public final boolean isComputed() {
        return this.myComputed;
    }

    @Override
    public void reset() {
        this.myComputed = false;
        this.mySolvable = null;
    }

    protected abstract PhysicalStore<N> allocate(long var1, long var3);

    protected boolean checkSolvability() {
        return false;
    }

    protected final boolean computed(boolean computed) {
        this.myComputed = computed;
        return this.myComputed;
    }

    protected abstract FunctionSet<N> function();

    protected final double getDimensionalEpsilon() {
        return (double)this.getMaxDim() * PrimitiveMath.MACHINE_EPSILON;
    }

    protected final boolean isAspectRatioNormal() {
        return this.getRowDim() >= this.getColDim();
    }

    protected abstract Scalar.Factory<N> scalar();

    boolean isSolvable() {
        if (this.myComputed && this.mySolvable == null) {
            this.mySolvable = this instanceof MatrixDecomposition.Solver ? Boolean.valueOf(this.checkSolvability()) : Boolean.FALSE;
        }
        return this.myComputed && this.mySolvable != null && this.mySolvable != false;
    }
}

