/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

final class SingleStore<N extends Comparable<N>>
extends FactoryStore<N> {
    private final N myNumber;
    private final double myValue;

    private SingleStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myNumber = null;
        this.myValue = 0.0;
        ProgrammingError.throwForIllegalInvocation();
    }

    SingleStore(PhysicalStore.Factory<N, ?> factory, Comparable<N> element) {
        super(factory, 1, 1);
        Scalar<N> converted = factory.scalar().convert(element);
        this.myNumber = (Comparable)converted.get();
        this.myValue = converted.doubleValue();
    }

    @Override
    public MatrixStore<N> conjugate() {
        return new SingleStore(this.physical(), (Comparable)((Scalar)this.physical().scalar().convert((Comparable<?>)this.myNumber).conjugate()).get());
    }

    @Override
    public double doubleValue(long anInd) {
        return this.myValue;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return this.myValue;
    }

    @Override
    public N get(long aRow, long aCol) {
        return this.myNumber;
    }

    @Override
    public void multiply(Access1D<N> right, TransformableRegion<N> target) {
        super.multiply(right, target);
    }

    @Override
    public MatrixStore<N> multiply(double scalar) {
        return super.multiply(scalar);
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        PhysicalStore.Factory tmpFactory = this.physical();
        PhysicalStore retVal = (PhysicalStore)tmpFactory.copy(right);
        retVal.modifyAll(tmpFactory.function().multiply().first(this.myNumber));
        return retVal;
    }

    @Override
    public MatrixStore<N> multiply(N scalar) {
        return super.multiply((Comparable)scalar);
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return super.multiplyBoth(leftAndRight);
    }

    @Override
    public ElementsSupplier<N> premultiply(Access1D<N> left) {
        return super.premultiply(left);
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        receiver.fillOne(0L, 0L, this.myNumber);
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return this.physical().scalar().convert((Comparable<?>)this.myNumber);
    }

    @Override
    public MatrixStore<N> transpose() {
        return this;
    }
}

