/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.ojalgo.RecoverableCondition;

public interface BasicParser<T> {
    default public void parse(File file, boolean skipHeader, Consumer<T> consumer) {
        block53: {
            if (file.exists() && file.isFile() && file.canRead()) {
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    String path = file.getPath();
                    if (path.endsWith(".zip")) {
                        try (InputStreamReader reader = new InputStreamReader(new ZipInputStream(fileInputStream));){
                            this.parse(reader, skipHeader, consumer);
                            break block53;
                        }
                    }
                    if (path.endsWith(".gz")) {
                        try (InputStreamReader reader = new InputStreamReader(new GZIPInputStream(fileInputStream));){
                            this.parse(reader, skipHeader, consumer);
                            break block53;
                        }
                    }
                    try (InputStreamReader reader = new InputStreamReader(fileInputStream);){
                        this.parse(reader, skipHeader, consumer);
                    }
                }
                catch (IOException cause) {
                    throw new RuntimeException(cause);
                }
            }
        }
    }

    default public void parse(File file, Consumer<T> consumer) {
        this.parse(file, false, consumer);
    }

    default public void parse(Reader reader, boolean skipHeader, Consumer<T> consumer) {
        String tmpLine = null;
        Object tmpItem = null;
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            if (skipHeader) {
                bufferedReader.readLine();
            }
            while ((tmpLine = bufferedReader.readLine()) != null) {
                try {
                    if (tmpLine.length() <= 0 || tmpLine.startsWith("#")) continue;
                    T t = this.parse(tmpLine);
                    tmpItem = t;
                    if (t == null) continue;
                    consumer.accept(tmpItem);
                }
                catch (RecoverableCondition recoverableCondition) {}
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    default public void parse(Reader reader, Consumer<T> consumer) {
        this.parse(reader, false, consumer);
    }

    public T parse(String var1) throws RecoverableCondition;

    default public void parse(String filePath, boolean skipHeader, Consumer<T> consumer) {
        this.parse(new File(filePath), skipHeader, consumer);
    }
}

