/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageLoadContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateClientStorageLoadContext
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String LOAD_NOT_NEEDED = "NoLoadNeeded";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateClientStorageLoadContext.class);
    @Nonnull
    @NonnullElements
    private Collection<ClientStorageService> storageServices = Collections.emptyList();

    public void setStorageServices(@Nonnull @NonnullElements Collection<ClientStorageService> services) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageServices = List.copyOf((Collection)Constraint.isNotNull(services, (String)"StorageService collection cannot be null"));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)LOAD_NOT_NEEDED);
            return false;
        }
        if (this.storageServices.isEmpty()) {
            this.log.debug("{} No ClientStorageServices supplied, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)LOAD_NOT_NEEDED);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ClientStorageLoadContext loadCtx = new ClientStorageLoadContext();
        ArrayList<String> ids = new ArrayList<String>();
        for (ClientStorageService service : this.storageServices) {
            try {
                if (service.isLoaded()) continue;
                loadCtx.getStorageKeys().add(service.getStorageName());
                ids.add(service.getId());
            }
            catch (IOException e) {
                this.log.warn("{} Error checking load status of {}, assuming unloaded", (Object)this.getLogPrefix(), (Object)service.getId());
                loadCtx.getStorageKeys().add(service.getStorageName());
                ids.add(service.getId());
            }
        }
        if (loadCtx.getStorageKeys().isEmpty()) {
            this.log.debug("{} No ClientStorageServices require loading, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)LOAD_NOT_NEEDED);
        } else {
            this.log.debug("{} ClientStorageServices requiring load: {}", (Object)this.getLogPrefix(), ids);
            profileRequestContext.addSubcontext((BaseContext)loadCtx, true);
        }
    }
}

