/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.event;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.analytics.action.PostAnalyticsEventAction;
import org.elasticsearch.xpack.application.analytics.event.AnalyticsEvent;
import org.elasticsearch.xpack.application.analytics.event.parser.event.PageViewAnalyticsEvent;
import org.elasticsearch.xpack.application.analytics.event.parser.event.SearchAnalyticsEvent;
import org.elasticsearch.xpack.application.analytics.event.parser.event.SearchClickAnalyticsEvent;

@Deprecated
public class AnalyticsEventFactory {
    public static final AnalyticsEventFactory INSTANCE = new AnalyticsEventFactory();
    private static final Map<AnalyticsEvent.Type, ContextParser<AnalyticsEvent.Context, AnalyticsEvent>> EVENT_PARSERS = Map.ofEntries(Map.entry(AnalyticsEvent.Type.PAGE_VIEW, PageViewAnalyticsEvent::fromXContent), Map.entry(AnalyticsEvent.Type.SEARCH, SearchAnalyticsEvent::fromXContent), Map.entry(AnalyticsEvent.Type.SEARCH_CLICK, SearchClickAnalyticsEvent::fromXContent));

    private AnalyticsEventFactory() {
    }

    public AnalyticsEvent fromRequest(PostAnalyticsEventAction.Request request) throws IOException {
        return this.fromPayload(request, request.xContentType(), request.payload());
    }

    public AnalyticsEvent fromPayload(AnalyticsEvent.Context context, XContentType xContentType, BytesReference payload) throws IOException {
        try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)payload, (XContentType)xContentType);){
            AnalyticsEvent.Type eventType = context.eventType();
            if (EVENT_PARSERS.containsKey((Object)eventType)) {
                AnalyticsEvent analyticsEvent = (AnalyticsEvent)EVENT_PARSERS.get((Object)eventType).parse(parser, (Object)context);
                return analyticsEvent;
            }
            throw new IllegalArgumentException(Strings.format((String)"[%s] is not a supported event type", (Object[])new Object[]{eventType}));
        }
    }
}

