/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.ItemSetBitSet;

public class TransactionsLookupTable
implements Accountable,
Releasable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TransactionsLookupTable.class);
    private final BigArrays bigArrays;
    private LongArray startOffsets;
    private LongArray longs;
    private long size;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionsLookupTable(long capacity, BigArrays bigArrays) {
        this.bigArrays = bigArrays;
        boolean success = false;
        try {
            this.startOffsets = bigArrays.newLongArray(capacity + 1L, false);
            this.startOffsets.set(0L, 0L);
            this.longs = bigArrays.newLongArray(capacity * 3L, false);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
        this.size = 0L;
    }

    public void append(ItemSetBitSet itemSetBitSet) {
        long startOffset = this.startOffsets.get(this.size);
        this.longs = this.bigArrays.grow(this.longs, startOffset + (long)itemSetBitSet.wordsInUse);
        for (int i = 0; i < itemSetBitSet.wordsInUse; ++i) {
            this.longs.set(startOffset + (long)i, itemSetBitSet.words[i]);
        }
        this.startOffsets = this.bigArrays.grow(this.startOffsets, this.size + 2L);
        this.startOffsets.set(this.size + 1L, startOffset + (long)itemSetBitSet.wordsInUse);
        ++this.size;
    }

    boolean isSubsetOf(long row, ItemSetBitSet set) {
        long startOffset = this.startOffsets.get(row);
        int wordsInUse = (int)(this.startOffsets.get(row + 1L) - startOffset);
        if (set.wordsInUse > wordsInUse) {
            return false;
        }
        for (int i = set.wordsInUse - 1; i >= 0; --i) {
            long word = this.longs.get(startOffset + (long)i);
            if ((word & set.words[i]) == set.words[i]) continue;
            return false;
        }
        return true;
    }

    public long size() {
        return this.size;
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.longs, this.startOffsets});
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.startOffsets.ramBytesUsed() + this.longs.ramBytesUsed();
    }
}

