/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.RefCountAwareThreadedActionListener;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;

public class ExpiredForecastsRemover
implements MlDataRemover {
    private static final Logger LOGGER = LogManager.getLogger(ExpiredForecastsRemover.class);
    private static final int MAX_FORECASTS = 10000;
    private static final String RESULTS_INDEX_PATTERN = AnomalyDetectorsIndex.jobResultsIndexPrefix() + "*";
    private final OriginSettingClient client;
    private final ThreadPool threadPool;
    private final long cutoffEpochMs;
    private final TaskId parentTaskId;

    public ExpiredForecastsRemover(OriginSettingClient client, ThreadPool threadPool, TaskId parentTaskId) {
        this.client = Objects.requireNonNull(client);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.cutoffEpochMs = Instant.now(Clock.systemDefaultZone()).toEpochMilli();
        this.parentTaskId = parentTaskId;
    }

    @Override
    public void remove(float requestsPerSec, ActionListener<Boolean> listener, BooleanSupplier isTimedOutSupplier) {
        LOGGER.debug("Removing forecasts that expire before [{}]", (Object)this.cutoffEpochMs);
        ActionListener forecastStatsHandler = ActionListener.wrap(searchResponse -> this.deleteForecasts((SearchResponse)searchResponse, requestsPerSec, listener, isTimedOutSupplier), e -> listener.onFailure((Exception)new ElasticsearchStatusException("An error occurred while searching forecasts to delete", RestStatus.TOO_MANY_REQUESTS, (Throwable)e, new Object[0])));
        SearchSourceBuilder source = new SearchSourceBuilder();
        source.query((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_forecast_request_stats")).filter((QueryBuilder)QueryBuilders.existsQuery((String)ForecastRequestStats.EXPIRY_TIME.getPreferredName())));
        source.size(10000);
        source.trackTotalHits(true);
        source.fetchSource(false);
        source.docValueField(Job.ID.getPreferredName(), null);
        source.docValueField(ForecastRequestStats.FORECAST_ID.getPreferredName(), null);
        source.docValueField(ForecastRequestStats.EXPIRY_TIME.getPreferredName(), "epoch_millis");
        source.sort("_doc");
        SearchRequest searchRequest = new SearchRequest(new String[]{RESULTS_INDEX_PATTERN});
        searchRequest.source(source);
        searchRequest.setParentTask(this.parentTaskId);
        this.client.execute(TransportSearchAction.TYPE, (ActionRequest)searchRequest, (ActionListener)new RefCountAwareThreadedActionListener((Executor)this.threadPool.executor("ml_utility"), forecastStatsHandler));
    }

    private void deleteForecasts(SearchResponse searchResponse, float requestsPerSec, final ActionListener<Boolean> listener, BooleanSupplier isTimedOutSupplier) {
        final List<JobForecastId> forecastsToDelete = this.findForecastsToDelete(searchResponse);
        if (forecastsToDelete.isEmpty()) {
            listener.onResponse((Object)true);
            return;
        }
        if (isTimedOutSupplier.getAsBoolean()) {
            listener.onResponse((Object)false);
            return;
        }
        DeleteByQueryRequest request = (DeleteByQueryRequest)((DeleteByQueryRequest)ExpiredForecastsRemover.buildDeleteByQuery(forecastsToDelete).setRequestsPerSecond(requestsPerSec)).setAbortOnVersionConflict(false);
        request.setParentTask(this.parentTaskId);
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<BulkByScrollResponse>(this){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                try {
                    if (bulkByScrollResponse.getDeleted() > 0L) {
                        LOGGER.info("Deleted [{}] documents corresponding to [{}] expired forecasts", (Object)bulkByScrollResponse.getDeleted(), (Object)forecastsToDelete.size());
                    }
                    listener.onResponse((Object)true);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof ElasticsearchException) {
                    ElasticsearchException elasticsearchException = (ElasticsearchException)e;
                    listener.onFailure((Exception)new ElasticsearchException("Failed to remove expired forecasts", new Object[]{elasticsearchException.status(), elasticsearchException}));
                } else {
                    listener.onFailure((Exception)new ElasticsearchStatusException("Failed to remove expired forecasts", RestStatus.TOO_MANY_REQUESTS, (Throwable)e, new Object[0]));
                }
            }
        });
    }

    private List<JobForecastId> findForecastsToDelete(SearchResponse searchResponse) {
        ArrayList<JobForecastId> forecastsToDelete = new ArrayList<JobForecastId>();
        SearchHits hits = searchResponse.getHits();
        if (hits.getTotalHits().value() > 10000L) {
            LOGGER.info("More than [{}] forecasts were found. This run will only delete [{}] of them", (Object)10000, (Object)10000);
        }
        for (SearchHit hit : hits.getHits()) {
            JobForecastId idPair;
            String expiryTime = this.stringFieldValueOrNull(hit, ForecastRequestStats.EXPIRY_TIME.getPreferredName());
            if (expiryTime == null) {
                LOGGER.warn("Forecast request stats document [{}] has a null [{}] field", (Object)hit.getId(), (Object)ForecastRequestStats.EXPIRY_TIME.getPreferredName());
                continue;
            }
            long expiryMs = TimeUtils.parseToEpochMs((String)expiryTime);
            if (expiryMs >= this.cutoffEpochMs || (idPair = new JobForecastId(this.stringFieldValueOrNull(hit, Job.ID.getPreferredName()), this.stringFieldValueOrNull(hit, Forecast.FORECAST_ID.getPreferredName()))).hasNullValue()) continue;
            forecastsToDelete.add(idPair);
        }
        return forecastsToDelete;
    }

    private static DeleteByQueryRequest buildDeleteByQuery(List<JobForecastId> ids) {
        DeleteByQueryRequest request = new DeleteByQueryRequest();
        request.setSlices(0);
        request.setTimeout(DEFAULT_MAX_DURATION);
        request.indices(new String[]{RESULTS_INDEX_PATTERN});
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().minimumShouldMatch(1);
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)Result.RESULT_TYPE.getPreferredName(), (String[])new String[]{"model_forecast_request_stats", "model_forecast"}));
        for (JobForecastId jobForecastId : ids) {
            if (jobForecastId.hasNullValue()) continue;
            boolQuery.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)jobForecastId.jobId)).must((QueryBuilder)QueryBuilders.termQuery((String)Forecast.FORECAST_ID.getPreferredName(), (String)jobForecastId.forecastId)));
        }
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)boolQuery);
        request.setQuery((QueryBuilder)query);
        request.getSearchRequest().source().sort("_doc");
        return request;
    }

    private static class JobForecastId {
        private final String jobId;
        private final String forecastId;

        private JobForecastId(String jobId, String forecastId) {
            this.jobId = jobId;
            this.forecastId = forecastId;
        }

        boolean hasNullValue() {
            return this.jobId == null || this.forecastId == null;
        }
    }
}

