/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;

public final class SourceDestValidations {
    private static final SourceDestValidator.SourceDestValidation REMOTE_SOURCE_VALIDATION = new SourceDestValidator.RemoteSourceEnabledAndRemoteLicenseValidation("transform");
    private static final List<SourceDestValidator.SourceDestValidation> PREVIEW_VALIDATIONS = Arrays.asList(SourceDestValidator.SOURCE_MISSING_VALIDATION, REMOTE_SOURCE_VALIDATION, SourceDestValidator.DESTINATION_PIPELINE_MISSING_VALIDATION);
    private static final List<SourceDestValidator.SourceDestValidation> ALL_VALIDATIONS = Arrays.asList(SourceDestValidator.SOURCE_MISSING_VALIDATION, REMOTE_SOURCE_VALIDATION, SourceDestValidator.DESTINATION_IN_SOURCE_VALIDATION, SourceDestValidator.DESTINATION_SINGLE_INDEX_VALIDATION, SourceDestValidator.DESTINATION_PIPELINE_MISSING_VALIDATION);
    private static final List<SourceDestValidator.SourceDestValidation> NON_DEFERABLE_VALIDATIONS = Collections.singletonList(SourceDestValidator.DESTINATION_SINGLE_INDEX_VALIDATION);

    private SourceDestValidations() {
    }

    public static List<SourceDestValidator.SourceDestValidation> getValidations(boolean isDeferValidation, List<SourceDestValidator.SourceDestValidation> additionalValidations) {
        return SourceDestValidations.getValidations(isDeferValidation, ALL_VALIDATIONS, additionalValidations);
    }

    public static List<SourceDestValidator.SourceDestValidation> getValidationsForPreview(List<SourceDestValidator.SourceDestValidation> additionalValidations) {
        return SourceDestValidations.getValidations(false, PREVIEW_VALIDATIONS, additionalValidations);
    }

    private static List<SourceDestValidator.SourceDestValidation> getValidations(boolean isDeferValidation, List<SourceDestValidator.SourceDestValidation> primaryValidations, List<SourceDestValidator.SourceDestValidation> additionalValidations) {
        if (isDeferValidation) {
            return NON_DEFERABLE_VALIDATIONS;
        }
        if (additionalValidations.isEmpty()) {
            return primaryValidations;
        }
        ArrayList<SourceDestValidator.SourceDestValidation> validations = new ArrayList<SourceDestValidator.SourceDestValidation>(primaryValidations);
        validations.addAll(additionalValidations);
        return validations;
    }
}

