/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.aggregations.support;

import java.util.Locale;
import java.util.function.LongSupplier;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.UnsupportedAggregationOnDownsampledIndex;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.aggregatemetric.aggregations.support.AggregateMetricsValuesSource;
import org.elasticsearch.xpack.aggregatemetric.fielddata.IndexAggregateMetricDoubleFieldData;

public enum AggregateMetricsValuesSourceType implements ValuesSourceType
{
    AGGREGATE_METRIC{

        public RuntimeException getUnregisteredException(String message) {
            return new UnsupportedAggregationOnDownsampledIndex(message);
        }

        public ValuesSource getEmpty() {
            throw new IllegalArgumentException("Can't deal with unmapped AggregateMetricsValuesSource type " + this.value());
        }

        public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
            throw AggregationErrors.valuesSourceDoesNotSupportScritps((String)this.value());
        }

        public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
            IndexFieldData indexFieldData = fieldContext.indexFieldData();
            if (!(indexFieldData instanceof IndexAggregateMetricDoubleFieldData)) {
                throw new IllegalArgumentException("Expected aggregate_metric_double type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
            }
            return new AggregateMetricsValuesSource.AggregateMetricDouble.Fielddata((IndexAggregateMetricDoubleFieldData)indexFieldData);
        }

        public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier nowInMillis) {
            throw new IllegalArgumentException("Can't apply missing values on a " + String.valueOf(valuesSource.getClass()));
        }
    };


    public String typeName() {
        return this.value();
    }

    public static ValuesSourceType fromString(String name) {
        return AggregateMetricsValuesSourceType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

