/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.concurrent.atomic.AtomicInteger;

public class Limiter {
    private final int limit;
    private final AtomicInteger collected = new AtomicInteger();
    public static Limiter NO_LIMIT = new Limiter(Integer.MAX_VALUE){

        @Override
        public int tryAccumulateHits(int numHits) {
            return numHits;
        }

        @Override
        public int remaining() {
            return Integer.MAX_VALUE;
        }
    };

    public Limiter(int limit) {
        this.limit = limit;
    }

    public int remaining() {
        int remaining = this.limit - this.collected.get();
        assert (remaining >= 0) : remaining;
        return remaining;
    }

    public int limit() {
        return this.limit;
    }

    public int tryAccumulateHits(int numHits) {
        int toAccept;
        int curVal;
        do {
            if ((curVal = this.collected.get()) < this.limit) continue;
            return 0;
        } while (!this.collected.compareAndSet(curVal, curVal + (toAccept = Math.min(this.limit - curVal, numHits))));
        return toAccept;
    }
}

