/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class StringExtractOperator
extends AbstractPageMappingOperator {
    private final String[] fieldNames;
    private final EvalOperator.ExpressionEvaluator inputEvaluator;
    private final Function<String, Map<String, String>> parser;
    private final DriverContext driverContext;

    public StringExtractOperator(String[] fieldNames, EvalOperator.ExpressionEvaluator inputEvaluator, Function<String, Map<String, String>> parser, DriverContext driverContext) {
        this.fieldNames = fieldNames;
        this.inputEvaluator = inputEvaluator;
        this.parser = parser;
        this.driverContext = driverContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Page process(Page page) {
        int rowsCount = page.getPositionCount();
        Releasable[] blockBuilders = new BytesRefBlock.Builder[this.fieldNames.length];
        try {
            for (int i = 0; i < this.fieldNames.length; ++i) {
                blockBuilders[i] = this.driverContext.blockFactory().newBytesRefBlockBuilder(rowsCount);
            }
            try (BytesRefBlock input = (BytesRefBlock)this.inputEvaluator.eval(page);){
                BytesRef spare = new BytesRef();
                for (int row = 0; row < rowsCount; ++row) {
                    if (input.isNull(row)) {
                        for (int i = 0; i < this.fieldNames.length; ++i) {
                            blockBuilders[i].appendNull();
                        }
                        continue;
                    }
                    int position = input.getFirstValueIndex(row);
                    int valueCount = input.getValueCount(row);
                    if (valueCount == 1) {
                        Map<String, String> items = this.parser.apply(input.getBytesRef(position, spare).utf8ToString());
                        if (items == null) {
                            for (int i = 0; i < this.fieldNames.length; ++i) {
                                blockBuilders[i].appendNull();
                            }
                            continue;
                        }
                        for (int i = 0; i < this.fieldNames.length; ++i) {
                            String val = items.get(this.fieldNames[i]);
                            BlockUtils.appendValue((Block.Builder)blockBuilders[i], val, ElementType.BYTES_REF);
                        }
                        continue;
                    }
                    String[] firstValues = new String[this.fieldNames.length];
                    boolean[] positionEntryOpen = new boolean[this.fieldNames.length];
                    for (int c = 0; c < valueCount; ++c) {
                        Map<String, String> items = this.parser.apply(input.getBytesRef(position + c, spare).utf8ToString());
                        if (items == null) continue;
                        for (int i = 0; i < this.fieldNames.length; ++i) {
                            String val = items.get(this.fieldNames[i]);
                            if (val == null) continue;
                            if (firstValues[i] == null) {
                                firstValues[i] = val;
                                continue;
                            }
                            if (!positionEntryOpen[i]) {
                                positionEntryOpen[i] = true;
                                blockBuilders[i].beginPositionEntry();
                                BlockUtils.appendValue((Block.Builder)blockBuilders[i], firstValues[i], ElementType.BYTES_REF);
                            }
                            BlockUtils.appendValue((Block.Builder)blockBuilders[i], val, ElementType.BYTES_REF);
                        }
                    }
                    for (int i = 0; i < this.fieldNames.length; ++i) {
                        if (positionEntryOpen[i]) {
                            blockBuilders[i].endPositionEntry();
                            continue;
                        }
                        if (firstValues[i] == null) {
                            blockBuilders[i].appendNull();
                            continue;
                        }
                        BlockUtils.appendValue((Block.Builder)blockBuilders[i], firstValues[i], ElementType.BYTES_REF);
                    }
                }
            }
            Block[] blocks = new Block[blockBuilders.length];
            for (int i = 0; i < blockBuilders.length; ++i) {
                blocks[i] = blockBuilders[i].build();
            }
            Page page2 = page.appendBlocks(blocks);
            return page2;
        }
        finally {
            Releasables.closeExpectNoException((Releasable[])blockBuilders);
        }
    }

    @Override
    public String toString() {
        return "StringExtractOperator[fields=[" + Arrays.stream(this.fieldNames).collect(Collectors.joining(", ")) + "]]";
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.inputEvaluator, () -> super.close()});
    }

    public record StringExtractOperatorFactory(String[] fieldNames, EvalOperator.ExpressionEvaluator.Factory expressionEvaluator, Supplier<Function<String, Map<String, String>>> parserSupplier) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new StringExtractOperator(this.fieldNames, this.expressionEvaluator.get(driverContext), this.parserSupplier.get(), driverContext);
        }

        @Override
        public String describe() {
            return "StringExtractOperator[fields=[" + Arrays.stream(this.fieldNames).collect(Collectors.joining(", ")) + "]]";
        }
    }
}

