/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.Deque;
import java.util.LinkedList;

public class UpdateSupport {
    private static final ThreadLocal<Deque<Deque<Runnable>>> deferredPublishersStack = ThreadLocal.withInitial(LinkedList::new);
    private static final ThreadLocal<Deque<Deque<Runnable>>> deferredTerminatorsStack = ThreadLocal.withInitial(LinkedList::new);
    private static final ThreadLocal<Boolean> isUpdate = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public static void deferPublication(Runnable runnable) {
        if (isUpdate.get().booleanValue()) {
            deferredPublishersStack.get().peekLast().addLast(runnable);
        } else {
            runnable.run();
        }
    }

    public static void deferTermination(Runnable runnable) {
        if (isUpdate.get().booleanValue()) {
            deferredTerminatorsStack.get().peekLast().addLast(runnable);
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUpdate(Runnable runnable) {
        Deque<Runnable> terminators;
        isUpdate.set(true);
        Deque<Deque<Runnable>> deferredPublishers = deferredPublishersStack.get();
        Deque<Deque<Runnable>> deferredTerminators = deferredTerminatorsStack.get();
        deferredPublishers.addLast(new LinkedList());
        deferredTerminators.addLast(new LinkedList());
        try {
            runnable.run();
            isUpdate.set(false);
            terminators = deferredTerminatorsStack.get().removeLast();
        }
        catch (Throwable throwable) {
            isUpdate.set(false);
            Deque<Runnable> terminators2 = deferredTerminatorsStack.get().removeLast();
            for (Runnable terminator : terminators2) {
                terminator.run();
            }
            Deque<Runnable> publishers = deferredPublishersStack.get().removeLast();
            for (Runnable publisher : publishers) {
                publisher.run();
            }
            isUpdate.set(!deferredTerminators.isEmpty());
            throw throwable;
        }
        for (Runnable terminator : terminators) {
            terminator.run();
        }
        Deque<Runnable> publishers = deferredPublishersStack.get().removeLast();
        for (Runnable publisher : publishers) {
            publisher.run();
        }
        isUpdate.set(!deferredTerminators.isEmpty());
    }
}

