/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.guava.util.concurrent;

import io.bazel.kotlin.builder.guava.annotations.GwtCompatible;
import io.bazel.kotlin.builder.guava.base.Preconditions;
import io.bazel.kotlin.builder.guava.util.concurrent.ElementTypesAreNonnullByDefault;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform {
    static boolean isInstanceOfThrowableClass(@CheckForNull Throwable t2, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t2);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t2) {
        Preconditions.checkNotNull(t2);
        if (t2 instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private Platform() {
    }
}

