<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2019-07-31  
Live at SIGGRAPH! and via Zoom  

Participants:
  * Chris Bankoff (Method)
  * Mark Boorer (ILM)
  * Michael Dolan (Imageworks)
  * Stephen Mackenzie (Method)
  * John Mertic (Linux Foundation)
  * Carl Rand (Foundry)
  * Matthias Scharfenberg (ILM)
  * Kevin Wheatley (Framestore)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)

Recording on Zoom cloud (speakerphone audio only this time):  
<https://zoom.us/rec/play/xssX7xfyZUrPjuNgLA10OIfUX2rxR55gb14kCRXl1lIDbm4rBs5pMWAiifGHSKSaS1w7IHdqUm-y7XWL.ZFchgXLp7Up-SgZJ?continueMode=true&_x_zm_rtaid=6QFJNe0ER9-6bB_b97WoNQ.1604340393164.4171031f9c4c6eb8bdf8f51f1711c959&_x_zm_rhtaid=257>


**RECAP OF CPU PERFORMANCE WORK**

   - Doug and Patrick reviewed this work, which has now been merged.  This
includes a start on some better integration with OIIO.
   - Michael:  Want to avoid OIIO dependencies that could cause compilation
order issues.
   - Michael:  The documentation will need careful updating to cover the new
features.  
   - Doug: Yes, ideally it would be nice to have the documentation in place by
mid next year to facilitate people coming up to speed on v2.
   - Stephen:  Perhaps add some "good first issue" items for documentation onto
GitHub.

**RECAP OF CLF/CTF WRITER WORK, PR #782**

   - Doug and Patrick reviewed this work, which is now a PR on GitHub.
   - Doug:  The support of CLF has been an ACES logo requirement.  Our
full-featured CLF implementation will hopefully encourage some additional apps
to adopt OCIO.  We have another PR in progress which would allow those apps to
access the individual ops, even if they need to translate them to use elsewhere
in their apps.
   - Kevin:  Yes, it's a valid approach.

**REMOVING REDUNDANT FLOAT POINTER ACCESSORS FROM API**

   - Doug:  We added double* accessors for a few transforms (Matrix, CDL, ...).
   - Matthias:  Yes, agree that the extra precision is sometimes needed.
   - Doug:  Is it ok if we remove the equivalent float* methods from the public
API to keep it cleaner?
   - Stephen:  Compatibility for the configs is important but minor dev changes
like this are ok.  Also, when else is your next chance to clean this up?  Should
remove it.
   - Group:  Yes, it's ok to do this sort of thing in a v2 upgrade.

**HANDLING OF NEGATIVES IN EXPONENT TRANSFORM**

   - Doug:  The OCIO v1 behavior was to clamp negatives, except if the
power=1.0, in which case negatives pass through.  I think this was done since in
v1 there was no dedicated CDL op and this behavior helped facilitate use of
simple unclamped offset+slope CDLs for neutralization, while still clamping
(which the ASC spec requires) for CDLs with power.  However, I don't like that
the clamp depends on what the power is and now that we have a dedicated CDL op
that offers the option of either not clamping or following the exact ASC math,
we could improve the exponent behavior.
   - Kevin:  Clamping is not good, and clamping based on the exponent is even
worse.
   - Group:  Yes, the v1 behavior is not good and should be revisited.
   - Doug:  Also, the ACES CLF VWG is currently looking at this since the plan
is to add an exponent transform to CLF v3.  It would be great if we can all
agree on how negatives should be handled.  There are three obvious alternatives:
always clamp negatives, pass negatives through unchanged, and pass negatives
through by reflecting the curve around the origin.
   - The group discussed the possibility of selecting just one of the options.
   - Doug:  In v1 there was no easy way to insert a negative clamp in a config
but now that may be done easily with the RangeTransform.  So I propose that we
settle on the no-clamp-with-reflection option and have people add an explicit
clamp if they want it.
   - Stephen:  Any differences in behavior should cause ociocheck to issue a
warning.
   - Doug:  There's also a connection between this and optimization.  There are
cases where two exponents could combine and become an identity.  As long as the
ops never clamp, this is no problem, but a clamp complicates things.  It means
an optimized result would not just be faster, it would also be different.
   - Stephen:  Perhaps decompose the transform under the hood into a separate
clamp and unclamped exponent.
   - Doug:  Yes, that would be a good idea if we can't settle on just one
option.
   - Group:  Yes, that would be ok to implement it like that.
   - Kevin, Michael, Stephen:  In practice, we need all three of those options
since there are examples of apps we need to emulate that use all three of those
approaches.
   - The group agreed that we should implement all three of those options and
provide a switch to control which one gets used from the config.
   - Doug will propose this to the CLF VWG.

**OCIO V2 RELEASE NAMING PROCESS**

   - Doug summarized the release plan that was presented at the BoF.
   - Doug:  Our previous discussion seemed to indicate the group wanted to call
the feature complete version 2.0.0 and so the stable final release would be
2.0.x.
   - Kevin:  I'd prefer to keep the 2.0.0 for the final release and put a prefix
on the tag for the earlier ones.
   - Stephen:  Perhaps put a date in the name.
   - Doug:  Larry was suggesting using tags like, *dev, *beta, *RC, etc.
suffixes.
   - Group:  Try to keep 2.0.0 name for final and use tag names to indicate
betas.
   - There was some initial discussion of branching but will be deferred until
later.
