//! This file is auto-generated by tools/update_cpu_features.zig.

const std = @import("../std.zig");
const CpuFeature = std.Target.Cpu.Feature;
const CpuModel = std.Target.Cpu.Model;

pub const Feature = enum {
    atomics,
    bulk_memory,
    bulk_memory_opt,
    call_indirect_overlong,
    exception_handling,
    extended_const,
    fp16,
    multimemory,
    multivalue,
    mutable_globals,
    nontrapping_bulk_memory_len0,
    nontrapping_fptoint,
    reference_types,
    relaxed_simd,
    sign_ext,
    simd128,
    tail_call,
    wide_arithmetic,
};

pub const featureSet = CpuFeature.FeatureSetFns(Feature).featureSet;
pub const featureSetHas = CpuFeature.FeatureSetFns(Feature).featureSetHas;
pub const featureSetHasAny = CpuFeature.FeatureSetFns(Feature).featureSetHasAny;
pub const featureSetHasAll = CpuFeature.FeatureSetFns(Feature).featureSetHasAll;

pub const all_features = blk: {
    const len = @typeInfo(Feature).@"enum".fields.len;
    std.debug.assert(len <= CpuFeature.Set.needed_bit_count);
    var result: [len]CpuFeature = undefined;
    result[@intFromEnum(Feature.atomics)] = .{
        .llvm_name = "atomics",
        .description = "Enable Atomics",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.bulk_memory)] = .{
        .llvm_name = "bulk-memory",
        .description = "Enable bulk memory operations",
        .dependencies = featureSet(&[_]Feature{
            .bulk_memory_opt,
        }),
    };
    result[@intFromEnum(Feature.bulk_memory_opt)] = .{
        .llvm_name = "bulk-memory-opt",
        .description = "Enable bulk memory optimization operations",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.call_indirect_overlong)] = .{
        .llvm_name = "call-indirect-overlong",
        .description = "Enable overlong encoding for call_indirect immediates",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.exception_handling)] = .{
        .llvm_name = "exception-handling",
        .description = "Enable Wasm exception handling",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.extended_const)] = .{
        .llvm_name = "extended-const",
        .description = "Enable extended const expressions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.fp16)] = .{
        .llvm_name = "fp16",
        .description = "Enable FP16 instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.multimemory)] = .{
        .llvm_name = "multimemory",
        .description = "Enable multiple memories",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.multivalue)] = .{
        .llvm_name = "multivalue",
        .description = "Enable multivalue blocks, instructions, and functions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.mutable_globals)] = .{
        .llvm_name = "mutable-globals",
        .description = "Enable mutable globals",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.nontrapping_bulk_memory_len0)] = .{
        .llvm_name = null,
        .description = "Bulk memory operations with a zero length do not trap",
        .dependencies = featureSet(&[_]Feature{
            .bulk_memory_opt,
        }),
    };
    result[@intFromEnum(Feature.nontrapping_fptoint)] = .{
        .llvm_name = "nontrapping-fptoint",
        .description = "Enable non-trapping float-to-int conversion operators",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.reference_types)] = .{
        .llvm_name = "reference-types",
        .description = "Enable reference types",
        .dependencies = featureSet(&[_]Feature{
            .call_indirect_overlong,
        }),
    };
    result[@intFromEnum(Feature.relaxed_simd)] = .{
        .llvm_name = "relaxed-simd",
        .description = "Enable relaxed-simd instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.sign_ext)] = .{
        .llvm_name = "sign-ext",
        .description = "Enable sign extension operators",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.simd128)] = .{
        .llvm_name = "simd128",
        .description = "Enable 128-bit SIMD",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.tail_call)] = .{
        .llvm_name = "tail-call",
        .description = "Enable tail call instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    result[@intFromEnum(Feature.wide_arithmetic)] = .{
        .llvm_name = "wide-arithmetic",
        .description = "Enable wide-arithmetic instructions",
        .dependencies = featureSet(&[_]Feature{}),
    };
    const ti = @typeInfo(Feature);
    for (&result, 0..) |*elem, i| {
        elem.index = i;
        elem.name = ti.@"enum".fields[i].name;
    }
    break :blk result;
};

pub const cpu = struct {
    pub const bleeding_edge: CpuModel = .{
        .name = "bleeding_edge",
        .llvm_name = "bleeding-edge",
        .features = featureSet(&[_]Feature{
            .atomics,
            .bulk_memory,
            .exception_handling,
            .extended_const,
            .fp16,
            .multimemory,
            .multivalue,
            .mutable_globals,
            .nontrapping_fptoint,
            .reference_types,
            .relaxed_simd,
            .sign_ext,
            .simd128,
            .tail_call,
        }),
    };
    pub const generic: CpuModel = .{
        .name = "generic",
        .llvm_name = "generic",
        .features = featureSet(&[_]Feature{
            .bulk_memory,
            .multivalue,
            .mutable_globals,
            .nontrapping_fptoint,
            .reference_types,
            .sign_ext,
        }),
    };
    pub const lime1: CpuModel = .{
        .name = "lime1",
        .llvm_name = "lime1",
        .features = featureSet(&[_]Feature{
            .bulk_memory_opt,
            .call_indirect_overlong,
            .extended_const,
            .multivalue,
            .mutable_globals,
            .nontrapping_fptoint,
            .sign_ext,
        }),
    };
    pub const mvp: CpuModel = .{
        .name = "mvp",
        .llvm_name = "mvp",
        .features = featureSet(&[_]Feature{}),
    };
};
