/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.backport.DefaultInterfaceMethodConverter;
import proguard.backport.JSR310Converter;
import proguard.backport.LambdaExpressionConverter;
import proguard.backport.StaticInterfaceMethodConverter;
import proguard.backport.StreamSupportConverter;
import proguard.backport.StringConcatenationConverter;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeToClassVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.BootstrapMethodsAttributeShrinker;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.InstructionSequencesReplacer;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.WarningLogger;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVersionSetter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.pass.Pass;

public class Backporter
implements Pass {
    private static final Logger logger = LogManager.getLogger(Backporter.class);
    private final Configuration configuration;

    public Backporter(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) throws IOException {
        int conversionWarningCount;
        ClassPoolFiller modifiedClassCollector;
        ClassPool modifiedClasses;
        int targetClassVersion = this.configuration.targetClassVersion;
        logger.info("Backporting class files...");
        appView.programClassPool.classesAccept(new ClassCleaner());
        appView.libraryClassPool.classesAccept(new ClassCleaner());
        InstructionCounter replacedStringConcatCounter = new InstructionCounter();
        ClassCounter lambdaExpressionCounter = new ClassCounter();
        MemberCounter staticInterfaceMethodCounter = new MemberCounter();
        MemberCounter defaultInterfaceMethodCounter = new MemberCounter();
        InstructionCounter replacedMethodCallCounter = new InstructionCounter();
        InstructionCounter replacedStreamsMethodCallCounter = new InstructionCounter();
        InstructionCounter replacedTimeMethodCallCounter = new InstructionCounter();
        if (targetClassVersion < 0x350000) {
            CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);
            appView.programClassPool.classesAccept(new ClassVersionFilter(0x350000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AttributeToClassVisitor(new MultiClassVisitor(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeEditor(codeAttributeEditor, new StringConcatenationConverter(replacedStringConcatCounter, codeAttributeEditor)))), new BootstrapMethodsAttributeShrinker(), new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool)))))));
        }
        if (targetClassVersion < 0x340000) {
            ClassPool filteredClasses = new ClassPool();
            appView.programClassPool.classesAccept(new ClassVersionFilter(0x340000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AttributeToClassVisitor(new ClassPoolFiller(filteredClasses))))));
            filteredClasses.classesAccept(new MultiClassVisitor(new LambdaExpressionConverter(appView.programClassPool, appView.libraryClassPool, appView.extraDataEntryNameMap, lambdaExpressionCounter), new BootstrapMethodsAttributeShrinker(), new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool)));
            ClassPool interfaceClasses = new ClassPool();
            appView.programClassPool.classesAccept(new ClassVersionFilter(0x340000, new ClassAccessFilter(512, 0, new ClassPoolFiller(interfaceClasses))));
            ClassPool modifiedClasses2 = new ClassPool();
            ClassPoolFiller modifiedClassCollector2 = new ClassPoolFiller(modifiedClasses2);
            interfaceClasses.classesAccept(new MultiClassVisitor(new StaticInterfaceMethodConverter(appView.programClassPool, appView.libraryClassPool, appView.extraDataEntryNameMap, modifiedClassCollector2, staticInterfaceMethodCounter), new DefaultInterfaceMethodConverter(modifiedClassCollector2, defaultInterfaceMethodCounter)));
            modifiedClasses2.classesAccept(new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool));
        }
        if (targetClassVersion < 0x330000) {
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder(appView.programClassPool, appView.libraryClassPool);
            Instruction[][][] instructions = new Instruction[][][]{{____.invokestatic("java/util/Objects", "requireNonNull", "(Ljava/lang/Object;)Ljava/lang/Object;").__(), ____.dup().invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;").pop().__()}, {____.invokevirtual("java/util/Throwable", "addSuppressed", "(Ljava/lang/Throwable;)V").__(), ____.pop().pop().__()}};
            Constant[] constants = ____.constants();
            CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
            appView.programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeEditor(null, codeAttributeEditor, new InstructionSequencesReplacer(constants, instructions, null, codeAttributeEditor, (InstructionVisitor)replacedMethodCallCounter)))));
        }
        if (targetClassVersion < 0x340000) {
            ClassCounter streamSupportClasses = new ClassCounter();
            ClassNameFilter streamSupportVisitor = new ClassNameFilter("java8/**", (ClassVisitor)streamSupportClasses);
            appView.programClassPool.classesAccept(streamSupportVisitor);
            appView.libraryClassPool.classesAccept(streamSupportVisitor);
            if (streamSupportClasses.getCount() > 0) {
                WarningLogger streamSupportWarningPrinter = new WarningLogger(logger, this.configuration.warn);
                modifiedClasses = new ClassPool();
                modifiedClassCollector = new ClassPoolFiller(modifiedClasses);
                appView.programClassPool.classesAccept(new ClassNameFilter("!java8/**", (ClassVisitor)new StreamSupportConverter(appView.programClassPool, appView.libraryClassPool, streamSupportWarningPrinter, modifiedClassCollector, replacedStreamsMethodCallCounter)));
                modifiedClasses.classesAccept(new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool));
                conversionWarningCount = ((WarningPrinter)streamSupportWarningPrinter).getWarningCount();
                if (conversionWarningCount > 0) {
                    logger.warn("Warning: there were {} Java 8 stream API method calls that could not be backported.", (Object)conversionWarningCount);
                    logger.warn("      You should check if a your project setup is correct (compileSdkVersion, streamsupport dependency).");
                    logger.warn("      For more information, consult the section 'Integration->Gradle Plugin->Java 8 stream API support' in our manual");
                }
            }
        }
        if (targetClassVersion < 0x340000) {
            ClassCounter threetenClasses = new ClassCounter();
            ClassNameFilter threetenClassVisitor = new ClassNameFilter("org/threeten/bp/**", (ClassVisitor)threetenClasses);
            appView.programClassPool.classesAccept(threetenClassVisitor);
            appView.libraryClassPool.classesAccept(threetenClassVisitor);
            if (threetenClasses.getCount() > 0) {
                WarningLogger threetenWarningPrinter = new WarningLogger(logger, this.configuration.warn);
                modifiedClasses = new ClassPool();
                modifiedClassCollector = new ClassPoolFiller(modifiedClasses);
                appView.programClassPool.classesAccept(new ClassNameFilter("!org/threeten/bp/**", (ClassVisitor)new JSR310Converter(appView.programClassPool, appView.libraryClassPool, threetenWarningPrinter, modifiedClassCollector, replacedTimeMethodCallCounter)));
                modifiedClasses.classesAccept(new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool));
                conversionWarningCount = ((WarningPrinter)threetenWarningPrinter).getWarningCount();
                if (conversionWarningCount > 0) {
                    logger.warn("Warning: there were {} Java 8 time API method calls that could not be backported.", (Object)conversionWarningCount);
                    logger.warn("      You should check if a your project setup is correct (compileSdkVersion, threetenbp dependency).");
                    logger.warn("      For more information, consult the section 'Integration->Gradle Plugin->Java 8 time API support' in our manual");
                }
            }
        }
        if (targetClassVersion != 0) {
            appView.programClassPool.classesAccept(new ClassVersionSetter(targetClassVersion));
        }
        logger.info("  Number of converted string concatenations:     {}", (Object)replacedStringConcatCounter.getCount());
        logger.info("  Number of converted lambda expressions:        {}", (Object)lambdaExpressionCounter.getCount());
        logger.info("  Number of converted static interface methods:  {}", (Object)staticInterfaceMethodCounter.getCount());
        logger.info("  Number of converted default interface methods: {}", (Object)defaultInterfaceMethodCounter.getCount());
        logger.info("  Number of replaced Java 7+ method calls:       {}", (Object)replacedMethodCallCounter.getCount());
        logger.info("  Number of replaced Java 8 stream method calls: {}", (Object)replacedStreamsMethodCallCounter.getCount());
        logger.info("  Number of replaced Java 8 time method calls:   {}", (Object)replacedTimeMethodCallCounter.getCount());
    }
}

