/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ArrayUtil;
import proguard.util.SimpleFeatureNamedProcessable;

public class LibraryClass
extends SimpleFeatureNamedProcessable
implements Clazz {
    private static final Clazz[] EMPTY_CLASSES = new Clazz[0];
    private static final String[] EMPTY_INTERFACES = new String[0];
    private static final LibraryField[] EMPTY_FIELDS = new LibraryField[0];
    private static final LibraryMethod[] EMPTY_METHODS = new LibraryMethod[0];
    public int u2accessFlags;
    public String thisClassName;
    public String superClassName;
    public String[] interfaceNames;
    public LibraryField[] fields;
    public LibraryMethod[] methods;
    public KotlinMetadata kotlinMetadata;
    public Clazz superClass;
    public Clazz[] interfaceClasses = EMPTY_CLASSES;
    public Clazz[] subClasses = EMPTY_CLASSES;
    public int subClassCount;

    public LibraryClass() {
    }

    public LibraryClass(int u2accessFlags, String thisClassName, String superClassName) {
        this(u2accessFlags, thisClassName, superClassName, null);
    }

    public LibraryClass(int u2accessFlags, String thisClassName, String superClassName, KotlinMetadata kotlinMetadata) {
        this(u2accessFlags, thisClassName, superClassName, EMPTY_INTERFACES, EMPTY_CLASSES, 0, EMPTY_CLASSES, EMPTY_FIELDS, EMPTY_METHODS, kotlinMetadata);
    }

    public LibraryClass(int u2accessFlags, String thisClassName, String superClassName, String[] interfaceNames, Clazz[] interfaceClasses, int subClassCount, Clazz[] subClasses, LibraryField[] fields, LibraryMethod[] methods, KotlinMetadata kotlinMetadata) {
        this.u2accessFlags = u2accessFlags;
        this.thisClassName = thisClassName;
        this.superClassName = superClassName;
        this.interfaceNames = interfaceNames;
        this.interfaceClasses = interfaceClasses;
        this.fields = fields;
        this.methods = methods;
        this.subClassCount = subClassCount;
        this.subClasses = subClasses;
        this.kotlinMetadata = kotlinMetadata;
    }

    boolean isVisible() {
        return (this.u2accessFlags & 1) != 0;
    }

    @Override
    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    @Override
    public String getName() {
        return this.thisClassName;
    }

    @Override
    public String getSuperName() {
        return this.superClassName;
    }

    @Override
    public int getInterfaceCount() {
        return this.interfaceClasses.length;
    }

    @Override
    public String getInterfaceName(int index) {
        return this.interfaceNames[index];
    }

    @Override
    public int getTag(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getString(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getStringString(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getClassName(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getName(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getType(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getRefClassName(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getRefName(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getRefType(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getModuleName(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public String getPackageName(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    @Override
    public void addSubClass(Clazz clazz) {
        this.subClasses = ArrayUtil.add(this.subClasses, this.subClassCount++, clazz);
    }

    @Override
    public void removeSubClass(Clazz clazz) {
        int newIndex = 0;
        for (int index = 0; index < this.subClassCount; ++index) {
            if (this.subClasses[index].equals(clazz)) continue;
            this.subClasses[newIndex++] = this.subClasses[index];
        }
        Arrays.fill(this.subClasses, newIndex, this.subClassCount, null);
        this.subClassCount = newIndex;
    }

    @Override
    public Clazz getSuperClass() {
        return this.superClass;
    }

    @Override
    public Clazz getInterface(int index) {
        return this.interfaceClasses[index];
    }

    @Override
    public boolean extends_(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        return this.superClass != null && this.superClass.extends_(clazz);
    }

    @Override
    public boolean extends_(String className) {
        if (this.getName().equals(className)) {
            return true;
        }
        return this.superClass != null && this.superClass.extends_(className);
    }

    @Override
    public boolean extendsOrImplements(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        if (this.superClass != null && this.superClass.extendsOrImplements(clazz)) {
            return true;
        }
        if (this.interfaceClasses != null) {
            for (int index = 0; index < this.interfaceClasses.length; ++index) {
                Clazz interfaceClass = this.interfaceClasses[index];
                if (interfaceClass == null || !interfaceClass.extendsOrImplements(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean extendsOrImplements(String className) {
        if (this.getName().equals(className)) {
            return true;
        }
        if (this.superClass != null && this.superClass.extendsOrImplements(className)) {
            return true;
        }
        if (this.interfaceClasses != null) {
            for (int index = 0; index < this.interfaceClasses.length; ++index) {
                Clazz interfaceClass = this.interfaceClasses[index];
                if (interfaceClass == null || !interfaceClass.extendsOrImplements(className)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Field findField(String name, String descriptor) {
        for (int index = 0; index < this.fields.length; ++index) {
            LibraryField field = this.fields[index];
            if (field == null || name != null && !field.getName(this).equals(name) || descriptor != null && !field.getDescriptor(this).equals(descriptor)) continue;
            return field;
        }
        return null;
    }

    @Override
    public Method findMethod(String name, String descriptor) {
        for (int index = 0; index < this.methods.length; ++index) {
            LibraryMethod method = this.methods[index];
            if (method == null || name != null && !method.getName(this).equals(name) || descriptor != null && !method.getDescriptor(this).equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitLibraryClass(this);
    }

    @Override
    public void hierarchyAccept(boolean visitThisClass, boolean visitSuperClass, boolean visitInterfaces, boolean visitSubclasses, ClassVisitor classVisitor) {
        int index;
        if (visitThisClass) {
            this.accept(classVisitor);
        }
        if (visitSuperClass && this.superClass != null) {
            this.superClass.hierarchyAccept(true, true, visitInterfaces, false, classVisitor);
        }
        if (visitInterfaces) {
            if (!visitSuperClass && this.superClass != null) {
                this.superClass.hierarchyAccept(false, false, true, false, classVisitor);
            }
            if (this.interfaceClasses != null) {
                for (index = 0; index < this.interfaceClasses.length; ++index) {
                    Clazz interfaceClass = this.interfaceClasses[index];
                    if (interfaceClass == null) continue;
                    interfaceClass.hierarchyAccept(true, false, true, false, classVisitor);
                }
            }
        }
        if (visitSubclasses) {
            for (index = 0; index < this.subClassCount; ++index) {
                this.subClasses[index].hierarchyAccept(true, false, false, true, classVisitor);
            }
        }
    }

    public void superClassAccept(ClassVisitor classVisitor) {
        if (this.superClass != null) {
            this.superClass.accept(classVisitor);
        }
    }

    public void interfacesAccept(ClassVisitor classVisitor) {
        if (this.interfaceClasses != null) {
            for (int index = 0; index < this.interfaceClasses.length; ++index) {
                Clazz interfaceClass = this.interfaceClasses[index];
                if (interfaceClass == null) continue;
                interfaceClass.accept(classVisitor);
            }
        }
    }

    @Override
    public void subclassesAccept(ClassVisitor classVisitor) {
        for (int index = 0; index < this.subClassCount; ++index) {
            this.subClasses[index].accept(classVisitor);
        }
    }

    @Override
    public void constantPoolEntriesAccept(ConstantVisitor constantVisitor) {
    }

    @Override
    public void constantPoolEntryAccept(int index, ConstantVisitor constantVisitor) {
    }

    @Override
    public void thisClassConstantAccept(ConstantVisitor constantVisitor) {
    }

    @Override
    public void superClassConstantAccept(ConstantVisitor constantVisitor) {
    }

    @Override
    public void interfaceConstantsAccept(ConstantVisitor constantVisitor) {
    }

    @Override
    public void fieldsAccept(MemberVisitor memberVisitor) {
        for (int index = 0; index < this.fields.length; ++index) {
            LibraryField field = this.fields[index];
            if (field == null) continue;
            field.accept((Clazz)this, memberVisitor);
        }
    }

    @Override
    public void fieldAccept(String name, String descriptor, MemberVisitor memberVisitor) {
        Field field = this.findField(name, descriptor);
        if (field != null) {
            field.accept(this, memberVisitor);
        }
    }

    @Override
    public void methodsAccept(MemberVisitor memberVisitor) {
        for (int index = 0; index < this.methods.length; ++index) {
            LibraryMethod method = this.methods[index];
            if (method == null) continue;
            method.accept((Clazz)this, memberVisitor);
        }
    }

    @Override
    public void methodAccept(String name, String descriptor, MemberVisitor memberVisitor) {
        Method method = this.findMethod(name, descriptor);
        if (method != null) {
            method.accept(this, memberVisitor);
        }
    }

    @Override
    public boolean mayHaveImplementations(Method method) {
        return (this.u2accessFlags & 0x10) == 0 && (method == null || (method.getAccessFlags() & 0x1A) == 0 && !method.getName(this).equals("<init>"));
    }

    @Override
    public void attributesAccept(AttributeVisitor attributeVisitor) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store attributes");
    }

    @Override
    public void attributeAccept(String name, AttributeVisitor attributeVisitor) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store attributes");
    }

    @Override
    public void kotlinMetadataAccept(KotlinMetadataVisitor kotlinMetadataVisitor) {
        if (this.kotlinMetadata != null) {
            this.kotlinMetadata.accept(this, kotlinMetadataVisitor);
        }
    }

    public String toString() {
        return "LibraryClass(" + this.getName() + ")";
    }
}

