/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberAccessFlagCleaner
implements ClassVisitor,
MemberVisitor {
    private final int accessFlags;

    public MemberAccessFlagCleaner(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2accessFlags &= ~this.accessFlags;
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.u2accessFlags &= ~this.accessFlags;
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.u2accessFlags &= ~this.accessFlags;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.u2accessFlags &= ~this.accessFlags;
    }
}

