/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ArrayUtil;

public class SubclassFilter
implements ClassVisitor {
    private final Clazz subclass;
    private final ClassVisitor classVisitor;

    public SubclassFilter(Clazz subclass, ClassVisitor classVisitor) {
        this.subclass = subclass;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (!this.present(programClass.subClasses, programClass.subClassCount)) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (!this.present(libraryClass.subClasses, libraryClass.subClassCount)) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean present(Clazz[] subClasses, int subClassCount) {
        return ArrayUtil.indexOf(subClasses, subClassCount, this.subclass) >= 0;
    }
}

